/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.core.utils.ClassLoaderUtil;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.internals.AbstractConfig;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class DefaultConfig
extends AbstractConfig
implements RepositoryChangeListener {
    private static final Logger logger = DeferredLoggerFactory.getLogger(DefaultConfig.class);
    private final String m_namespace;
    private final Properties m_resourceProperties;
    private final AtomicReference<Properties> m_configProperties;
    private final ConfigRepository m_configRepository;
    private final RateLimiter m_warnLogRateLimiter;
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.NONE;

    public DefaultConfig(String namespace, ConfigRepository configRepository) {
        this.m_namespace = namespace;
        this.m_resourceProperties = this.loadFromResource(this.m_namespace);
        this.m_configRepository = configRepository;
        this.m_configProperties = new AtomicReference();
        this.m_warnLogRateLimiter = RateLimiter.create(0.017);
        this.initialize();
    }

    private void initialize() {
        try {
            this.updateConfig(this.m_configRepository.getConfig(), this.m_configRepository.getSourceType());
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            logger.warn("Init Apollo Local Config failed - namespace: {}, reason: {}.", (Object)this.m_namespace, (Object)ExceptionUtil.getDetailMessage(ex));
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    protected String getPropertyFromRepository(String key) {
        Properties properties = this.m_configProperties.get();
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    protected String getPropertyFromAdditional(String key) {
        Properties properties = this.m_resourceProperties;
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    protected void tryWarnLog(String value) {
        if (value == null && this.m_configProperties.get() == null && this.m_warnLogRateLimiter.tryAcquire()) {
            logger.warn("Could not load config for namespace {} from Apollo, please check whether the configs are released in Apollo! Return default value now!", (Object)this.m_namespace);
        }
    }

    protected Set<String> getPropertyNamesFromRepository() {
        Properties properties = this.m_configProperties.get();
        if (properties == null) {
            return Collections.emptySet();
        }
        return this.stringPropertyNames(properties);
    }

    protected Set<String> getPropertyNamesFromAdditional() {
        Properties properties = this.m_resourceProperties;
        if (properties == null) {
            return Collections.emptySet();
        }
        return this.stringPropertyNames(properties);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.getPropertyFromRepository(key);
        }
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null) {
            value = this.getPropertyFromAdditional(key);
        }
        this.tryWarnLog(value);
        return value == null ? defaultValue : value;
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> fromRepository = this.getPropertyNamesFromRepository();
        Set<String> fromAdditional = this.getPropertyNamesFromAdditional();
        if (fromRepository == null || fromRepository.isEmpty()) {
            return fromAdditional;
        }
        if (fromAdditional == null || fromAdditional.isEmpty()) {
            return fromRepository;
        }
        LinkedHashSet<String> propertyNames = Sets.newLinkedHashSetWithExpectedSize(fromRepository.size() + fromAdditional.size());
        propertyNames.addAll(fromRepository);
        propertyNames.addAll(fromAdditional);
        return propertyNames;
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    private Set<String> stringPropertyNames(Properties properties) {
        LinkedHashMap<String, String> h2 = Maps.newLinkedHashMapWithExpectedSize(properties.size());
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String) || !(v instanceof String)) continue;
            h2.put((String)k, (String)v);
        }
        return h2.keySet();
    }

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties.get())) {
            return;
        }
        ConfigSourceType sourceType = this.m_configRepository.getSourceType();
        Properties newConfigProperties = this.propertiesFactory.getPropertiesInstance();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        Map<String, ConfigChange> actualChanges = this.updateAndCalcConfigChanges(newConfigProperties, sourceType);
        if (actualChanges.isEmpty()) {
            return;
        }
        this.fireConfigChange(this.m_namespace, actualChanges);
        Tracer.logEvent("Apollo.Client.ConfigChanges", this.m_namespace);
    }

    private void updateConfig(Properties newConfigProperties, ConfigSourceType sourceType) {
        this.m_configProperties.set(newConfigProperties);
        this.m_sourceType = sourceType;
    }

    private Map<String, ConfigChange> updateAndCalcConfigChanges(Properties newConfigProperties, ConfigSourceType sourceType) {
        List<ConfigChange> configChanges = this.calcPropertyChanges(this.m_namespace, this.m_configProperties.get(), newConfigProperties);
        ImmutableMap.Builder<String, ConfigChange> actualChanges = new ImmutableMap.Builder<String, ConfigChange>();
        for (ConfigChange change : configChanges) {
            change.setOldValue(this.getProperty(change.getPropertyName(), change.getOldValue()));
        }
        this.updateConfig(newConfigProperties, sourceType);
        this.clearConfigCache();
        for (ConfigChange change : configChanges) {
            change.setNewValue(this.getProperty(change.getPropertyName(), change.getNewValue()));
            switch (change.getChangeType()) {
                case ADDED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    if (change.getOldValue() != null) {
                        change.setChangeType(PropertyChangeType.MODIFIED);
                    }
                    actualChanges.put(change.getPropertyName(), change);
                    break;
                }
                case MODIFIED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    actualChanges.put(change.getPropertyName(), change);
                    break;
                }
                case DELETED: {
                    if (Objects.equals(change.getOldValue(), change.getNewValue())) break;
                    if (change.getNewValue() != null) {
                        change.setChangeType(PropertyChangeType.MODIFIED);
                    }
                    actualChanges.put(change.getPropertyName(), change);
                    break;
                }
            }
        }
        return actualChanges.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromResource(String namespace) {
        String name = String.format("META-INF/config/%s.properties", namespace);
        InputStream in = ClassLoaderUtil.getLoader().getResourceAsStream(name);
        Properties properties = null;
        if (in != null) {
            properties = this.propertiesFactory.getPropertiesInstance();
            try {
                properties.load(in);
            }
            catch (IOException ex) {
                Tracer.logError(ex);
                logger.error("Load resource config for namespace {} failed", (Object)namespace, (Object)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

