/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.springcloud;

import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.springcloud.SpringCloudPlugin;
import org.apache.shenyu.plugin.springcloud.context.SpringCloudShenyuContextDecorator;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.listener.SpringCloudHeartBeatListener;
import org.apache.shenyu.plugin.springcloud.loadbalance.ShenyuSpringCloudServiceChooser;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.spring-cloud.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringCloudPluginConfiguration {
    @Bean
    public ShenyuSpringCloudServiceChooser shenyuSpringCloudLoadBalancerClient() {
        return new ShenyuSpringCloudServiceChooser();
    }

    @Bean
    public ShenyuPlugin springCloudPlugin(ObjectProvider<ShenyuSpringCloudServiceChooser> serviceChooser) {
        return new SpringCloudPlugin((ShenyuSpringCloudServiceChooser)serviceChooser.getIfAvailable());
    }

    @Bean
    public ShenyuContextDecorator springCloudShenyuContextDecorator() {
        return new SpringCloudShenyuContextDecorator();
    }

    @Bean
    public PluginDataHandler springCloudPluginDataHandler(ShenyuConfig shenyuConfig, Environment env) {
        return new SpringCloudPluginDataHandler(shenyuConfig.getSpringCloudCache(), env);
    }

    @Bean
    public SpringCloudHeartBeatListener springCloudHeartBeatListener(ShenyuConfig shenyuConfig) {
        return new SpringCloudHeartBeatListener(shenyuConfig.getSpringCloudCache());
    }
}

