/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.metrics.boot;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.metrics.reporter.MetricsReporter;
import org.apache.shenyu.plugin.metrics.spi.MetricsRegister;
import org.apache.shenyu.plugin.metrics.spi.MetricsService;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;

public class MetricsRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRunner.class);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final ShenyuConfig.MetricsConfig config;
    private MetricsService metricsService;

    public MetricsRunner(ShenyuConfig.MetricsConfig config) {
        this.config = config;
    }

    public void run(String ... args) {
        if (this.isStarted.compareAndSet(false, true)) {
            this.metricsService = (MetricsService)ExtensionLoader.getExtensionLoader(MetricsService.class).getJoin(this.config.getName());
            Preconditions.checkNotNull((Object)this.metricsService, (String)"Can not find metrics service with metrics name : %s in metrics configuration.", (Object)this.config.getName());
            MetricsRegister metricsRegister = (MetricsRegister)ExtensionLoader.getExtensionLoader(MetricsRegister.class).getJoin(this.config.getName());
            Preconditions.checkNotNull((Object)metricsRegister, (String)"Can not find metrics register with metrics name : %s in metrics configuration.", (Object)this.config.getName());
            MetricsReporter.register((MetricsRegister)metricsRegister);
            this.metricsService.start(this.config, metricsRegister);
        } else {
            LOG.info("metrics service has started!");
        }
    }

    public void destroy() {
        this.isStarted.compareAndSet(true, false);
        Optional.ofNullable(this.metricsService).ifPresent(MetricsService::stop);
    }
}

