/*
 * Decompiled with CFR 0.152.
 */
package org.apache.springboot.starter.client.grpc;

import java.util.Objects;
import java.util.Properties;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.ClientRegisterConfigImpl;
import org.apache.shenyu.client.grpc.GrpcClientEventListener;
import org.apache.shenyu.client.grpc.server.GrpcServerBuilder;
import org.apache.shenyu.client.grpc.server.GrpcServerRunner;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.springboot.starter.client.common.config.ShenyuClientCommonBeanConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ImportAutoConfiguration(value={ShenyuClientCommonBeanConfiguration.class})
@ConditionalOnProperty(value={"shenyu.register.enabled"}, matchIfMissing=true, havingValue="true")
public class ShenyuGrpcClientConfiguration {
    @Bean
    public GrpcClientEventListener grpcClientEventListener(ShenyuClientConfig clientConfig, Environment env, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        ShenyuClientConfig.ClientPropertiesConfig clientPropertiesConfig = (ShenyuClientConfig.ClientPropertiesConfig)clientConfig.getClient().get(RpcTypeEnum.GRPC.getName());
        Properties props = Objects.isNull(clientPropertiesConfig) ? null : clientPropertiesConfig.getProps();
        String discoveryMode = env.getProperty("shenyu.discovery.type", "local");
        if (Objects.nonNull(props)) {
            props.setProperty("discoveryLocalMode", Boolean.valueOf("local".equals(discoveryMode)).toString());
        }
        return new GrpcClientEventListener(clientConfig, shenyuClientRegisterRepository);
    }

    @Bean
    public GrpcServerRunner grpcServer(GrpcServerBuilder grpcServerBuilder, GrpcClientEventListener grpcClientEventListener) {
        return new GrpcServerRunner(grpcServerBuilder, grpcClientEventListener);
    }

    @Bean(value={"grpcClientRegisterConfig"})
    public ClientRegisterConfig clientRegisterConfig(ShenyuClientConfig shenyuClientConfig, ApplicationContext applicationContext, Environment env) {
        return new ClientRegisterConfigImpl(shenyuClientConfig, RpcTypeEnum.GRPC, applicationContext, env);
    }

    static {
        VersionUtils.checkDuplicate(ShenyuGrpcClientConfiguration.class);
    }
}

