/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.spring.EnableShenyuClients;
import org.apache.shenyu.sdk.spring.ShenyuClient;
import org.apache.shenyu.sdk.spring.ShenyuClientFactoryBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ShenyuClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    ShenyuClientsRegistrar() {
    }

    static void validateFallback(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @ShenyuClient");
    }

    static void validateFallbackFactory(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @ShenyuClient");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerShenyuClients(metadata, registry);
    }

    public void registerShenyuClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        LinkedHashSet candidateComponents = new LinkedHashSet();
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ShenyuClient.class));
        Set<String> basePackages = this.getBasePackages(metadata);
        for (String basePackage : basePackages) {
            candidateComponents.addAll(scanner.findCandidateComponents(basePackage));
        }
        for (BeanDefinition candidateComponent : candidateComponents) {
            if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
            AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
            Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)("@ShenyuClient can only be specified on an interface " + candidateComponent.getBeanClassName()));
            Map attributes = annotationMetadata.getAnnotationAttributes(ShenyuClient.class.getCanonicalName());
            this.registerShenyuClient(registry, annotationMetadata, attributes);
        }
    }

    private void registerShenyuClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        Class clazz = ClassUtils.resolveClassName((String)className, null);
        ConfigurableBeanFactory beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : null;
        String contextId = this.getContextId(beanFactory, attributes);
        String name = this.getName(attributes);
        ShenyuClientFactoryBean factoryBean = new ShenyuClientFactoryBean();
        factoryBean.setBeanFactory((BeanFactory)beanFactory);
        factoryBean.setName(name);
        factoryBean.setContextId(contextId);
        factoryBean.setType(clazz);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, () -> {
            Object fallbackFactory;
            factoryBean.setUrl(this.getUrl(beanFactory, attributes));
            factoryBean.setPath(this.getPath(beanFactory, attributes));
            Object fallback = attributes.get("fallback");
            if (Objects.nonNull(fallback)) {
                factoryBean.setFallback(fallback instanceof Class ? (Class)fallback : ClassUtils.resolveClassName((String)fallback.toString(), null));
            }
            if (Objects.nonNull(fallbackFactory = attributes.get("fallbackFactory"))) {
                factoryBean.setFallbackFactory(fallbackFactory instanceof Class ? (Class)fallbackFactory : ClassUtils.resolveClassName((String)fallbackFactory.toString(), null));
            }
            return factoryBean;
        });
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        this.validate(attributes);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        beanDefinition.setAttribute("shenyuClientsRegistrarFactoryBean", (Object)factoryBean);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        Object[] qualifiers = this.getQualifiers(attributes);
        if (ObjectUtils.isEmpty((Object[])qualifiers)) {
            qualifiers = new String[]{Optional.ofNullable(contextId).orElse(name) + "ShenyuClient"};
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, (String[])qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        ShenyuClientsRegistrar.validateFallback(annotation.getClass("fallback"));
        ShenyuClientsRegistrar.validateFallbackFactory(annotation.getClass("fallbackFactory"));
    }

    private String getContextId(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String contextId = (String)attributes.get("contextId");
        if (StringUtils.isBlank((CharSequence)contextId)) {
            return this.getName(attributes);
        }
        contextId = this.resolve(beanFactory, contextId);
        return ShenyuClientsRegistrar.getName(contextId);
    }

    private String resolve(ConfigurableBeanFactory beanFactory, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (Objects.isNull(beanFactory)) {
                return this.environment.resolvePlaceholders(value);
            }
            String resolved = beanFactory.resolveEmbeddedValue(value);
            BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
            if (Objects.isNull(resolver)) {
                return resolved;
            }
            Object evaluateValue = resolver.evaluate(resolved, new BeanExpressionContext(beanFactory, null));
            if (Objects.nonNull(evaluateValue)) {
                return String.valueOf(evaluateValue);
            }
            return null;
        }
        return value;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableShenyuClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.isNotBlank((CharSequence)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.isNotBlank((CharSequence)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private String getQualifier(Map<String, Object> client) {
        if (Objects.isNull(client)) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.isNotBlank((CharSequence)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private String[] getQualifiers(Map<String, Object> client) {
        if (Objects.isNull(client)) {
            return null;
        }
        List<String> qualifierList = new ArrayList<String>(Arrays.asList((String[])client.get("qualifiers")));
        qualifierList.removeIf(qualifier -> StringUtils.isBlank((CharSequence)qualifier));
        if (CollectionUtils.isEmpty(qualifierList) && StringUtils.isNotBlank((CharSequence)this.getQualifier(client))) {
            qualifierList = Collections.singletonList(this.getQualifier(client));
        }
        return CollectionUtils.isNotEmpty(qualifierList) ? qualifierList.toArray(new String[0]) : null;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static String getName(String name) {
        String host;
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        try {
            Object url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI((String)url).getHost();
        }
        catch (URISyntaxException e) {
            host = null;
        }
        Assert.state((boolean)Objects.nonNull(host), (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    String getName(Map<String, Object> attributes) {
        return this.getName(null, attributes);
    }

    String getName(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String name = (String)attributes.get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(beanFactory, name);
        return ShenyuClientsRegistrar.getName(name);
    }

    static String getUrl(String url) {
        Object resultUrl = url;
        if (!(!StringUtils.isNotBlank((CharSequence)resultUrl) || ((String)resultUrl).startsWith("#{") && ((String)resultUrl).contains("}"))) {
            if (!((String)resultUrl).contains("://")) {
                resultUrl = "http://" + (String)resultUrl;
            }
            if (((String)resultUrl).endsWith("/")) {
                resultUrl = ((String)resultUrl).substring(0, ((String)resultUrl).length() - 1);
            }
            try {
                new URL((String)resultUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException((String)resultUrl + " is malformed", e);
            }
        }
        return resultUrl;
    }

    private String getUrl(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String url = this.resolve(beanFactory, (String)attributes.get("url"));
        if (StringUtils.isBlank((CharSequence)url)) {
            return ShenyuClientsRegistrar.getUrl(this.getName(beanFactory, attributes));
        }
        return ShenyuClientsRegistrar.getUrl(url);
    }

    private String getPath(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String path = this.resolve(beanFactory, (String)attributes.get("path"));
        return ShenyuClientsRegistrar.getPath(path);
    }

    static String getPath(String path) {
        Object resultPath = path;
        if (StringUtils.isNotBlank((CharSequence)resultPath)) {
            if (!((String)(resultPath = ((String)resultPath).trim())).startsWith("/")) {
                resultPath = "/" + (String)resultPath;
            }
            if (((String)resultPath).endsWith("/")) {
                resultPath = ((String)resultPath).substring(0, ((String)resultPath).length() - 1);
            }
        }
        return resultPath;
    }
}

