/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.spring.ShenyuClientFactoryBean;
import org.apache.shenyu.sdk.spring.factory.Contract;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringMvcContract
extends Contract.BaseContract {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Override
    public RequestTemplate parseRequestTemplate(Method method, ShenyuClientFactoryBean shenyuClientFactoryBean) {
        RequestTemplate requestTemplate = new RequestTemplate();
        requestTemplate.setMethod(method);
        requestTemplate.setReturnType(method.getReturnType());
        for (Annotation methodAnnotation : method.getAnnotations()) {
            this.processAnnotationOnMethod(requestTemplate, methodAnnotation, method, shenyuClientFactoryBean);
        }
        return requestTemplate;
    }

    protected void processAnnotationOnMethod(RequestTemplate requestTemplate, Annotation methodAnnotation, Method method, ShenyuClientFactoryBean shenyuClientFactoryBean) {
        Object pathValue;
        if (!(methodAnnotation instanceof RequestMapping) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        requestTemplate.setHttpMethod(ShenyuRequest.HttpMethod.valueOf((String)methods[0].name()));
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && StringUtils.isNotBlank((CharSequence)(pathValue = methodMapping.value()[0]))) {
            if (!((String)(pathValue = this.resolve((String)pathValue))).startsWith("/") && StringUtils.isNotBlank((CharSequence)shenyuClientFactoryBean.getPath()) && !shenyuClientFactoryBean.getPath().endsWith("/")) {
                pathValue = "/" + (String)pathValue;
            }
            requestTemplate.setPath((String)pathValue);
        }
        this.parseProduces(requestTemplate, methodMapping);
        this.parseConsumes(requestTemplate, methodMapping);
        this.parseHeaders(requestTemplate, methodMapping);
    }

    private void parseProduces(RequestTemplate requestTemplate, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = serverProduces.length == 0 ? null : (clientAccepts = serverProduces[0].isEmpty() ? null : serverProduces[0]);
        if (Objects.nonNull(clientAccepts)) {
            requestTemplate.getHeaders().put(ACCEPT, Collections.singleton(clientAccepts));
        }
    }

    private void parseConsumes(RequestTemplate requestTemplate, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = serverConsumes.length == 0 ? null : (clientProduces = serverConsumes[0].isEmpty() ? null : serverConsumes[0]);
        if (Objects.nonNull(clientProduces)) {
            requestTemplate.getHeaders().put(CONTENT_TYPE, Collections.singleton(clientProduces));
        }
    }

    private void parseHeaders(RequestTemplate requestTemplate, RequestMapping annotation) {
        for (String header : annotation.headers()) {
            int index = header.indexOf(61);
            if (header.contains("!=") || index < 0) continue;
            requestTemplate.getHeaders().put(this.resolve(header.substring(0, index)), Collections.singleton(this.resolve(header.substring(index + 1).trim())));
        }
    }

    private String resolve(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Assert.state((Objects.nonNull(values) && values.length == 1 ? 1 : 0) != 0, (String)String.format("Method %s can only contain 1 %s field. Found: %s", method.getName(), fieldName, Objects.isNull(values) ? null : Arrays.asList(values)));
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Assert.state((Objects.nonNull(values) && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)String.format("Method %s can only contain at most 1 %s field. Found: %s", method.getName(), fieldName, Arrays.asList(values)));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

