/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.sdk.core.client.ShenyuSdkClient;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.spring.FallbackFactory;
import org.apache.shenyu.sdk.spring.NoFallbackAvailableException;
import org.apache.shenyu.sdk.spring.ShenyuClient;
import org.apache.shenyu.sdk.spring.ShenyuClientFactoryBean;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.apache.shenyu.sdk.spring.factory.Contract;
import org.apache.shenyu.sdk.spring.proxy.ShenyuClientMethodHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ShenyuClientInvocationHandler
implements InvocationHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(ShenyuClientInvocationHandler.class);
    private final Map<Method, ShenyuClientMethodHandler> methodHandlerMap = new ConcurrentHashMap<Method, ShenyuClientMethodHandler>();
    private final ApplicationContext applicationContext;
    private final Contract contract;
    private final ShenyuClientFactoryBean shenyuClientFactoryBean;
    private final FallbackFactory<?> fallbackFactory;

    public ShenyuClientInvocationHandler(Class<?> apiClass, ApplicationContext applicationContext, ShenyuClientFactoryBean shenyuClientFactoryBean) {
        this.shenyuClientFactoryBean = shenyuClientFactoryBean;
        this.applicationContext = applicationContext;
        this.contract = (Contract)applicationContext.getBean(Contract.class);
        ShenyuClient shenyuClient = apiClass.getAnnotation(ShenyuClient.class);
        this.fallbackFactory = this.getFallbackFactory(shenyuClientFactoryBean.getFallback(), shenyuClientFactoryBean.getFallbackFactory());
        this.buildMethodHandlerMap(apiClass, shenyuClient);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        ShenyuClientMethodHandler handler = this.methodHandlerMap.get(method);
        if (ObjectUtils.isEmpty((Object)handler)) {
            throw new ShenyuException(String.format("the method cannot be called, please check the annotation and configuration, method %s", method.getName()));
        }
        try {
            result = handler.invoke(args);
        }
        catch (Throwable throwable) {
            LOG.error("ShenYu Client invoke error  ", throwable);
            if (Objects.isNull(this.fallbackFactory)) {
                throw new NoFallbackAvailableException("No fallback available.", throwable);
            }
            Object fallback = this.fallbackFactory.create(throwable);
            result = method.invoke(fallback, args);
        }
        return result;
    }

    private void buildMethodHandlerMap(Class<?> apiClass, ShenyuClient shenyuClient) {
        List<RequestTemplate> requestTemplates = this.contract.parseAndValidateRequestTemplate(apiClass, this.shenyuClientFactoryBean);
        ShenyuSdkClient shenyuSdkClient = (ShenyuSdkClient)this.applicationContext.getBean(ShenyuSdkClient.class);
        Map annotatedParameterProcessorMap = this.applicationContext.getBeansOfType(AnnotatedParameterProcessor.class);
        Collection annotatedParameterProcessors = annotatedParameterProcessorMap.values();
        annotatedParameterProcessors = annotatedParameterProcessors.stream().sorted(Comparator.comparing(AnnotatedParameterProcessor::order)).collect(Collectors.toList());
        Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors = this.toAnnotatedArgumentProcessorMap(annotatedParameterProcessors);
        for (RequestTemplate requestTemplate : requestTemplates) {
            requestTemplate.setUrl(this.shenyuClientFactoryBean.getUrl());
            requestTemplate.setName(this.shenyuClientFactoryBean.getName());
            requestTemplate.setContextId(Optional.ofNullable(this.shenyuClientFactoryBean.getContextId()).orElse(this.shenyuClientFactoryBean.getName()));
            if (StringUtils.hasText((String)this.shenyuClientFactoryBean.getPath())) {
                requestTemplate.setPath(this.shenyuClientFactoryBean.getPath() + requestTemplate.getPath());
            }
            this.methodHandlerMap.put(requestTemplate.getMethod(), new ShenyuClientMethodHandler(shenyuClient, requestTemplate, shenyuSdkClient, annotatedArgumentProcessors));
        }
    }

    private Map<Class<? extends Annotation>, AnnotatedParameterProcessor> toAnnotatedArgumentProcessorMap(Collection<AnnotatedParameterProcessor> processors) {
        HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor> result = new HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor>();
        for (AnnotatedParameterProcessor processor : processors) {
            result.put(processor.getAnnotationType(), processor);
        }
        return result;
    }

    private FallbackFactory<?> getFallbackFactory(Class<?> fallback, Class<?> fallbackFactory) {
        try {
            if (fallback != Void.TYPE) {
                Object fallbackInstance = this.applicationContext.getBean(fallback);
                return new FallbackFactory.Default<Object>(fallbackInstance);
            }
            if (fallbackFactory != Void.TYPE) {
                return (FallbackFactory)this.applicationContext.getBean(fallbackFactory);
            }
            return null;
        }
        catch (BeansException exception) {
            LOG.error("No fallback available ", (Throwable)exception);
            return null;
        }
    }
}

