/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.core.util.Types;
import org.apache.shenyu.sdk.core.util.Util;
import org.apache.shenyu.sdk.spring.ShenyuClientFactoryBean;
import org.springframework.context.ResourceLoaderAware;

public interface Contract
extends ResourceLoaderAware {
    public List<RequestTemplate> parseAndValidateRequestTemplate(Class<?> var1, ShenyuClientFactoryBean var2);

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<RequestTemplate> parseAndValidateRequestTemplate(Class<?> targetType, ShenyuClientFactoryBean shenyuClientFactoryBean) {
            Util.checkState((targetType.getTypeParameters().length == 0 ? 1 : 0) != 0, (String)"Parameterized types unsupported: %s", (Object[])new Object[]{targetType.getSimpleName()});
            Util.checkState((targetType.getInterfaces().length <= 1 ? 1 : 0) != 0, (String)"Only single inheritance supported: %s", (Object[])new Object[]{targetType.getSimpleName()});
            LinkedHashMap<Method, RequestTemplate> result = new LinkedHashMap<Method, RequestTemplate>();
            for (Method method : targetType.getMethods()) {
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault((Method)method)) continue;
                RequestTemplate parseRequestTemplate = this.parseRequestTemplate(method, shenyuClientFactoryBean);
                parseRequestTemplate.setParamMetadataList(this.analysisParamMetadata(method));
                if (result.containsKey(method)) {
                    Class overridingReturnType;
                    RequestTemplate existingMetadata = (RequestTemplate)result.get(method);
                    Class existingReturnType = existingMetadata.getReturnType();
                    Type resolvedType = Types.resolveReturnType((Type)existingReturnType, (Type)(overridingReturnType = parseRequestTemplate.getReturnType()));
                    if (resolvedType.equals(overridingReturnType)) {
                        result.put(method, parseRequestTemplate);
                    }
                    result.put(method, existingMetadata);
                    continue;
                }
                result.put(method, parseRequestTemplate);
            }
            return new ArrayList<RequestTemplate>(result.values());
        }

        private List<RequestTemplate.ParamMetadata> analysisParamMetadata(Method method) {
            Parameter[] parameters = method.getParameters();
            if (Objects.isNull(parameters) || parameters.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<RequestTemplate.ParamMetadata> params = new ArrayList<RequestTemplate.ParamMetadata>(parameters.length);
            for (int index = 0; index < parameters.length; ++index) {
                Annotation[] annotations = parameters[index].getAnnotations();
                if (Objects.isNull(annotations) || annotations.length == 0) continue;
                params.add(new RequestTemplate.ParamMetadata(annotations, parameters[index].getType(), index));
            }
            return params;
        }

        public abstract RequestTemplate parseRequestTemplate(Method var1, ShenyuClientFactoryBean var2);
    }
}

