/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface FallbackFactory<T> {
    public T create(Throwable var1);

    public static final class Default<T>
    implements FallbackFactory<T> {
        private final Log logger;
        private final T constant;

        public Default(T constant) {
            this(constant, LogFactory.getLog(Default.class));
        }

        Default(T constant, Log logger) {
            this.constant = Preconditions.checkNotNull(constant, (Object)"fallback");
            this.logger = (Log)Preconditions.checkNotNull((Object)logger, (Object)"logger");
        }

        @Override
        public T create(Throwable cause) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("fallback due to: " + cause.getMessage()), cause);
            }
            return this.constant;
        }

        public String toString() {
            return this.constant.toString();
        }
    }
}

