/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.util.EntityUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.ShenyuResponse;
import org.apache.shenyu.sdk.core.client.AbstractShenyuSdkClient;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class HttpShenyuSdkClient
extends AbstractShenyuSdkClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpShenyuSdkClient.class);
    private PoolingNHttpClientConnectionManager connectionManager;
    private RequestConfig requestConfig;
    private HttpAsyncClient httpAsyncClient;

    protected void initClient(Properties props) {
        try {
            String maxTotal = props.getProperty("http.maxTotal", "800");
            String maxPerRoute = props.getProperty("http.maxPerRoute", "200");
            String serverRequestTimeOut = props.getProperty("http.serverRequestTimeOut", "2000");
            String serverResponseTimeOut = props.getProperty("http.serverResponseTimeOut", "2000");
            String connectionRequestTimeOut = props.getProperty("http.connectionRequestTimeOut ", "2000");
            Registry sessionStrategyRegistry = RegistryBuilder.create().register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy()).register("http", (Object)NoopIOSessionStrategy.INSTANCE).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
            this.connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, sessionStrategyRegistry);
            this.connectionManager.setMaxTotal(Integer.parseInt(maxTotal));
            this.connectionManager.setDefaultMaxPerRoute(Integer.parseInt(maxPerRoute));
            this.requestConfig = RequestConfig.custom().setSocketTimeout(Integer.parseInt(serverRequestTimeOut)).setConnectTimeout(Integer.parseInt(serverResponseTimeOut)).setConnectionRequestTimeout(Integer.parseInt(connectionRequestTimeOut)).build();
            this.httpAsyncClient = this.getHttpClient();
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private HttpAsyncClient getHttpClient() {
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setDefaultRequestConfig(this.requestConfig).setConnectionManager((NHttpClientConnectionManager)this.connectionManager).build();
        client.start();
        return client;
    }

    protected ShenyuResponse doRequest(ShenyuRequest request) throws IOException {
        String url = request.getUrl();
        String body = request.getBody();
        RequestBuilder requestBuilder = switch (request.getHttpMethod()) {
            case ShenyuRequest.HttpMethod.GET -> RequestBuilder.get((String)url);
            case ShenyuRequest.HttpMethod.HEAD -> RequestBuilder.head((String)url);
            case ShenyuRequest.HttpMethod.POST -> RequestBuilder.post((String)url);
            case ShenyuRequest.HttpMethod.PUT -> RequestBuilder.put((String)url);
            case ShenyuRequest.HttpMethod.DELETE -> RequestBuilder.delete((String)url);
            case ShenyuRequest.HttpMethod.OPTIONS -> RequestBuilder.options((String)url);
            case ShenyuRequest.HttpMethod.TRACE -> RequestBuilder.trace((String)url);
            default -> RequestBuilder.patch((String)url);
        };
        if (StringUtils.isNotBlank((CharSequence)body)) {
            requestBuilder.setEntity((HttpEntity)this.createStringEntity(body));
        }
        Map headers = request.getHeaders();
        for (String name : headers.keySet()) {
            for (String value : (Collection)headers.get(name)) {
                requestBuilder.addHeader(name, value);
            }
        }
        Future execute = this.httpAsyncClient.execute(requestBuilder.build(), (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                LOG.debug("HttpResponse completed statusLine={}", (Object)response.getStatusLine());
            }

            public void failed(Exception ex) {
                LOG.error("HttpResponse failed", (Throwable)ex);
            }

            public void cancelled() {
                LOG.debug("HttpResponse cancelled.");
            }
        });
        try {
            HttpResponse response = (HttpResponse)execute.get();
            return new ShenyuResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), (Map)Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, HashMap::new, Collectors.mapping(NameValuePair::getValue, Collectors.toCollection(LinkedList::new)))), EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8), request);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private StringEntity createStringEntity(String body) {
        StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
        stringEntity.setContentType("application/json;charset=UTF-8");
        return stringEntity;
    }
}

