/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt.repositories;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.protocol.mqtt.repositories.BaseRepository;

public class TopicRepository
implements BaseRepository<String, String> {
    private static final Map<String, String> TOPIC_FACTORY = new ConcurrentHashMap<String, String>();

    @Override
    public void add(String topic, String message) {
        CompletableFuture.runAsync(() -> TOPIC_FACTORY.put(topic, message));
    }

    @Override
    public void remove(String topic) {
        TOPIC_FACTORY.remove(topic);
    }

    @Override
    public String get(String topic) {
        return TOPIC_FACTORY.getOrDefault(topic, null);
    }
}

