/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.shenyu.protocol.mqtt.MqttTransportHandler;

public class MqttTransportServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final int maxPayloadSize;

    public MqttTransportServerInitializer(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new MqttDecoder(this.maxPayloadSize));
        pipeline.addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
        MqttTransportHandler handler = new MqttTransportHandler();
        pipeline.addLast(new ChannelHandler[]{handler});
        ch.closeFuture().addListener((GenericFutureListener)handler);
    }
}

