/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt.repositories;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.protocol.mqtt.repositories.BaseRepository;

public class ChannelRepository
implements BaseRepository<Channel, String> {
    private static final Map<Channel, String> CHANNEL_FACTORY = new ConcurrentHashMap<Channel, String>();

    @Override
    public void add(Channel channel, String clientId) {
        CompletableFuture.runAsync(() -> CHANNEL_FACTORY.put(channel, clientId));
    }

    @Override
    public void remove(Channel channel) {
        CHANNEL_FACTORY.remove(channel);
    }

    @Override
    public String get(Channel channel) {
        return CHANNEL_FACTORY.get(channel);
    }
}

