/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.util.Locale;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.protocol.mqtt.BootstrapServer;
import org.apache.shenyu.protocol.mqtt.MqttContext;
import org.apache.shenyu.protocol.mqtt.MqttTransportServerInitializer;
import org.apache.shenyu.protocol.mqtt.repositories.BaseRepository;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MqttBootstrapServer
implements BootstrapServer {
    private static final String REPOSITORY_PACKAGE_NAME = "org.apache.shenyu.protocol.mqtt.repositories";
    private static final MqttContext ENV = new MqttContext();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelFuture future;

    @Override
    public void init() {
        try {
            this.initRepositories();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.valueOf((String)ENV.getLeakDetectorLevel().toUpperCase(Locale.ROOT)));
        this.bossGroup = new NioEventLoopGroup(ENV.getBossGroupThreadCount());
        this.workerGroup = new NioEventLoopGroup(ENV.getWorkerGroupThreadCount());
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new MqttTransportServerInitializer(ENV.getMaxPayloadSize()));
        try {
            this.future = bootstrap.bind(ENV.getPort()).sync();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.future.channel().close();
    }

    private void initRepositories() throws IllegalAccessException, InstantiationException {
        Reflections reflections = new Reflections(REPOSITORY_PACKAGE_NAME, new Scanner[0]);
        for (Class clazz : reflections.getSubTypesOf(BaseRepository.class)) {
            Singleton.INST.single(clazz, clazz.newInstance());
        }
    }
}

