/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.wasm.base.handler;

import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.plugin.wasm.api.exception.ShenyuWasmInitException;
import org.apache.shenyu.plugin.wasm.api.loader.WasmLoader;

public abstract class AbstractWasmMetaDataHandler
extends WasmLoader
implements MetaDataHandler {
    protected static final Map<Long, MetaData> ARGUMENTS = new ConcurrentHashMap<Long, MetaData>();
    protected static final String HANDLE_METHOD_NAME = "handleMetaData";
    protected static final String REMOVE_METHOD_NAME = "removeMetaData";
    protected static final String REFRESH_METHOD_NAME = "refresh";

    public void handle(MetaData metaData) {
        super.getWasmExtern(HANDLE_METHOD_NAME).map(handle -> this.callWASI(metaData, (Extern)handle)).orElseThrow(() -> new ShenyuWasmInitException("handleMetaData function not find in wasm file: " + this.getWasmName()));
    }

    public void remove(MetaData metaData) {
        super.getWasmExtern(REMOVE_METHOD_NAME).map(remove -> this.callWASI(metaData, (Extern)remove)).orElseThrow(() -> new ShenyuWasmInitException("removeMetaData function not find in wasm file: " + this.getWasmName()));
    }

    private Long callWASI(MetaData metaData, Extern execute) {
        Long argumentId = this.getArgumentId(metaData);
        ARGUMENTS.put(argumentId, metaData);
        WasmFunctions.consumer((Store)super.getStore(), (Func)execute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    protected abstract Long getArgumentId(MetaData var1);

    public void refresh() {
        super.getWasmExtern(REFRESH_METHOD_NAME).ifPresent(refresh -> WasmFunctions.consumer((Store)super.getStore(), (Func)refresh.func()).accept());
    }
}

