/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.wasm.base.handler;

import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.wasm.api.loader.WasmLoader;

public abstract class AbstractWasmPluginDataHandler
extends WasmLoader
implements PluginDataHandler {
    protected static final Map<Long, PluginData> PLUGIN_ARGUMENTS = new ConcurrentHashMap<Long, PluginData>();
    protected static final String HANDLER_PLUGIN_METHOD_NAME = "handlerPlugin";
    protected static final String REMOVE_PLUGIN_METHOD_NAME = "removePlugin";
    protected static final Map<Long, SelectorData> SELECTOR_ARGUMENTS = new ConcurrentHashMap<Long, SelectorData>();
    protected static final String HANDLER_SELECTOR_METHOD_NAME = "handlerSelector";
    protected static final String REMOVE_SELECTOR_METHOD_NAME = "removeSelector";
    protected static final Map<Long, RuleData> RULE_ARGUMENTS = new ConcurrentHashMap<Long, RuleData>();
    protected static final String HANDLER_RULE_METHOD_NAME = "handlerRule";
    protected static final String REMOVE_RULE_METHOD_NAME = "removeRule";

    public void handlerPlugin(PluginData pluginData) {
        super.getWasmExtern(HANDLER_PLUGIN_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(pluginData, (Extern)handlerPlugin));
    }

    public void removePlugin(PluginData pluginData) {
        super.getWasmExtern(REMOVE_PLUGIN_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(pluginData, (Extern)handlerPlugin));
    }

    public void handlerSelector(SelectorData selectorData) {
        super.getWasmExtern(HANDLER_SELECTOR_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(selectorData, (Extern)handlerPlugin));
    }

    public void removeSelector(SelectorData selectorData) {
        super.getWasmExtern(REMOVE_SELECTOR_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(selectorData, (Extern)handlerPlugin));
    }

    public void handlerRule(RuleData ruleData) {
        super.getWasmExtern(HANDLER_RULE_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(ruleData, (Extern)handlerPlugin));
    }

    public void removeRule(RuleData ruleData) {
        super.getWasmExtern(REMOVE_RULE_METHOD_NAME).ifPresent(handlerPlugin -> this.callWASI(ruleData, (Extern)handlerPlugin));
    }

    private Long callWASI(PluginData pluginData, Extern execute) {
        Long argumentId = this.getPluginArgumentId(pluginData);
        PLUGIN_ARGUMENTS.put(argumentId, pluginData);
        WasmFunctions.consumer((Store)super.getStore(), (Func)execute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        PLUGIN_ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    private Long callWASI(RuleData ruleData, Extern execute) {
        Long argumentId = this.getRuleArgumentId(ruleData);
        RULE_ARGUMENTS.put(argumentId, ruleData);
        WasmFunctions.consumer((Store)super.getStore(), (Func)execute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        RULE_ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    private Long callWASI(SelectorData selectorData, Extern execute) {
        Long argumentId = this.getSelectorArgumentId(selectorData);
        SELECTOR_ARGUMENTS.put(argumentId, selectorData);
        WasmFunctions.consumer((Store)super.getStore(), (Func)execute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        SELECTOR_ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    protected Long getPluginArgumentId(PluginData pluginData) {
        return 0L;
    }

    protected Long getSelectorArgumentId(SelectorData selectorData) {
        return 0L;
    }

    protected Long getRuleArgumentId(RuleData ruleData) {
        return 0L;
    }
}

