/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.transform;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.BodyParamUtils;
import org.apache.shenyu.plugin.base.utils.HttpParamConverter;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RpcParamTransformPlugin
implements ShenyuPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        if (Objects.nonNull(shenyuContext)) {
            MediaType mediaType = request.getHeaders().getContentType();
            if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                return this.body(exchange, request, chain);
            }
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
                return this.formData(exchange, request, chain);
            }
            return this.query(exchange, request, chain);
        }
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.RPC_PARAM_TRANSFORM.getCode();
    }

    public String named() {
        return PluginEnum.RPC_PARAM_TRANSFORM.getName();
    }

    private Mono<Void> body(ServerWebExchange exchange, ServerHttpRequest serverHttpRequest, ShenyuPluginChain chain) {
        return Mono.from((Publisher)DataBufferUtils.join((Publisher)serverHttpRequest.getBody()).flatMap(data -> Mono.just(Optional.of(data))).defaultIfEmpty(Optional.empty()).flatMap(body -> {
            body.ifPresent(dataBuffer -> exchange.getAttributes().put("param_transform", this.resolveBodyFromRequest((DataBuffer)dataBuffer)));
            return chain.execute(exchange);
        }));
    }

    private Mono<Void> formData(ServerWebExchange exchange, ServerHttpRequest serverHttpRequest, ShenyuPluginChain chain) {
        return Mono.from((Publisher)DataBufferUtils.join((Publisher)serverHttpRequest.getBody()).flatMap(data -> Mono.just(Optional.of(data))).defaultIfEmpty(Optional.empty()).flatMap(map -> {
            if (map.isPresent()) {
                String param = this.resolveBodyFromRequest((DataBuffer)map.get());
                LinkedMultiValueMap linkedMultiValueMap = BodyParamUtils.buildBodyParams((String)URLDecoder.decode(param, StandardCharsets.UTF_8));
                exchange.getAttributes().put("param_transform", HttpParamConverter.toMap(() -> linkedMultiValueMap));
            }
            return chain.execute(exchange);
        }));
    }

    private Mono<Void> query(ServerWebExchange exchange, ServerHttpRequest serverHttpRequest, ShenyuPluginChain chain) {
        exchange.getAttributes().put("param_transform", HttpParamConverter.ofString(() -> serverHttpRequest.getURI().getQuery()));
        return chain.execute(exchange);
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.DUBBO, RpcTypeEnum.GRPC, RpcTypeEnum.TARS, RpcTypeEnum.MOTAN, RpcTypeEnum.SOFA});
    }

    @NonNull
    private String resolveBodyFromRequest(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

