/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mqtt.handler;

import java.net.InetAddress;
import java.net.Socket;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.protocol.mqtt.BootstrapServer;
import org.apache.shenyu.protocol.mqtt.MqttBootstrapServer;
import org.apache.shenyu.protocol.mqtt.MqttServerConfiguration;

public class MqttPluginDataHandler
implements PluginDataHandler {
    private final BootstrapServer server = new MqttBootstrapServer();

    public void handlerPlugin(PluginData pluginData) {
        MqttServerConfiguration configuration = (MqttServerConfiguration)GsonUtils.getInstance().fromJson(pluginData.getConfig(), MqttServerConfiguration.class);
        configuration.afterPropertiesSet();
        if (pluginData.getEnabled().booleanValue()) {
            this.server.init();
            this.server.start();
        } else if (this.isPortUsing(configuration.getPort())) {
            this.server.shutdown();
        }
    }

    public String pluginNamed() {
        return PluginEnum.MQTT.getName();
    }

    private boolean isPortUsing(int port) {
        boolean flag = false;
        try (Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), port);){
            flag = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }
}

