/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.util;

import org.apache.shenyu.plugin.mock.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public final class EvaluationContextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationContextUtil.class);

    private EvaluationContextUtil() {
    }

    public static void init(EvaluationContext context) {
        try {
            EvaluationContextUtil.registerMockFunction(context, "double", "randomDouble", Double.TYPE, Double.TYPE, String[].class);
            EvaluationContextUtil.registerMockFunction(context, "bool", "bool", new Class[0]);
            EvaluationContextUtil.registerMockFunction(context, "int", "randomInt", Integer.TYPE, Integer.TYPE);
            EvaluationContextUtil.registerMockFunction(context, "email", "email", new Class[0]);
            EvaluationContextUtil.registerMockFunction(context, "phone", "phone", new Class[0]);
            EvaluationContextUtil.registerMockFunction(context, "zh", "zh", Integer.TYPE, Integer.TYPE);
            EvaluationContextUtil.registerMockFunction(context, "en", "en", Integer.TYPE, Integer.TYPE);
            EvaluationContextUtil.registerMockFunction(context, "oneOf", "oneOf", Object[].class);
            EvaluationContextUtil.registerMockFunction(context, "current", "current", String[].class);
            EvaluationContextUtil.registerMockFunction(context, "array", "array", Object.class, Integer.TYPE);
            EvaluationContextUtil.registerMockFunction(context, "nowDate", "nowDate", new Class[0]);
            EvaluationContextUtil.registerMockFunction(context, "nowTime", "nowTime", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void registerMockFunction(EvaluationContext context, String name, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        context.setVariable(name, (Object)MockUtil.class.getDeclaredMethod(methodName, parameterTypes));
    }
}

