/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.shenyu.common.utils.GsonUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NonCommittingMcpResponseDecorator
extends ServerHttpResponseDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(NonCommittingMcpResponseDecorator.class);
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private final String sessionId;
    private final CompletableFuture<String> responseFuture;
    private final JsonObject responseTemplate;

    public NonCommittingMcpResponseDecorator(ServerHttpResponse delegate, String sessionId, CompletableFuture<String> responseFuture, JsonObject responseTemplate) {
        super(delegate);
        this.sessionId = sessionId;
        this.responseFuture = responseFuture;
        this.responseTemplate = responseTemplate;
        LOG.debug("Created non-committing MCP response decorator for session: {}", (Object)sessionId);
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        LOG.debug("Processing writeWith for session: {}", (Object)this.sessionId);
        return Flux.from(body).collectList().doOnNext(this::processResponseData).then().doOnSuccess(aVoid -> LOG.debug("Successfully completed writeWith for session: {}", (Object)this.sessionId)).doOnError(error -> this.handleProcessingError("writeWith", (Throwable)error));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        LOG.debug("Processing writeAndFlushWith for session: {}", (Object)this.sessionId);
        return Flux.from(body).flatMap(Flux::from).collectList().doOnNext(this::processResponseData).then().doOnSuccess(aVoid -> LOG.debug("Successfully completed writeAndFlushWith for session: {}", (Object)this.sessionId)).doOnError(error -> this.handleProcessingError("writeAndFlushWith", (Throwable)error));
    }

    private void processResponseData(List<? extends DataBuffer> dataBuffers) {
        try {
            String responseBody = this.aggregateDataBuffers(dataBuffers);
            LOG.debug("Captured response data for session {}, length: {} chars", (Object)this.sessionId, (Object)responseBody.length());
            String processedResponse = this.processResponse(responseBody);
            LOG.debug("Processed response for session {}, final length: {} chars", (Object)this.sessionId, (Object)processedResponse.length());
            this.responseFuture.complete(processedResponse);
        }
        catch (Exception e) {
            LOG.error("Error processing response data for session {}: {}", new Object[]{this.sessionId, e.getMessage(), e});
            this.responseFuture.completeExceptionally(e);
        }
    }

    private String aggregateDataBuffers(List<? extends DataBuffer> dataBuffers) {
        StringBuilder responseBuilder = new StringBuilder();
        for (DataBuffer dataBuffer : dataBuffers) {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            responseBuilder.append(new String(bytes, StandardCharsets.UTF_8));
        }
        return responseBuilder.toString();
    }

    private void handleProcessingError(String operation, Throwable error) {
        LOG.error("Error in {} operation for session {}: {}", new Object[]{operation, this.sessionId, error.getMessage(), error});
        this.responseFuture.completeExceptionally(error);
    }

    private String processResponse(String responseBody) {
        try {
            if (Objects.isNull(this.responseTemplate) || this.responseTemplate.size() == 0) {
                return responseBody;
            }
            JsonObject responseJson = this.parseResponseAsJson(responseBody);
            if (Objects.isNull(responseJson)) {
                LOG.debug("Response is not valid JSON for session: {}, returning unchanged", (Object)this.sessionId);
                return responseBody;
            }
            return this.applyResponseTemplate(responseJson);
        }
        catch (Exception e) {
            LOG.error("Error applying response template for session {}: {}", (Object)this.sessionId, (Object)e.getMessage());
            return responseBody;
        }
    }

    private JsonObject parseResponseAsJson(String responseBody) {
        try {
            return (JsonObject)GsonUtils.getInstance().fromJson(responseBody, JsonObject.class);
        }
        catch (Exception e) {
            LOG.debug("Failed to parse response as JSON for session: {}", (Object)this.sessionId);
            return null;
        }
    }

    private String applyResponseTemplate(JsonObject responseJson) {
        JsonObject processedResponse = new JsonObject();
        if (!this.responseTemplate.has("content")) {
            return GsonUtils.getInstance().toJson((Object)responseJson);
        }
        JsonObject contentTemplate = this.responseTemplate.getAsJsonObject("content");
        JsonObject content = this.buildContentFromTemplate(contentTemplate, responseJson);
        processedResponse.add("content", (JsonElement)content);
        return GsonUtils.getInstance().toJson((Object)processedResponse);
    }

    private JsonObject buildContentFromTemplate(JsonObject contentTemplate, JsonObject responseData) {
        JsonObject content = new JsonObject();
        if (contentTemplate.has("type")) {
            content.addProperty("type", contentTemplate.get("type").getAsString());
        }
        if (contentTemplate.has("text")) {
            String textTemplate = contentTemplate.get("text").getAsString();
            String processedText = this.applyPlaceholderSubstitution(textTemplate, responseData);
            content.addProperty("text", processedText);
        }
        return content;
    }

    private String applyPlaceholderSubstitution(String template, JsonObject responseData) {
        if (Objects.isNull(responseData)) {
            return template;
        }
        String result = template;
        for (String key : responseData.keySet()) {
            String placeholder = PLACEHOLDER_PREFIX + key + PLACEHOLDER_SUFFIX;
            if (!result.contains(placeholder)) continue;
            String value = responseData.get(key).isJsonPrimitive() ? responseData.get(key).getAsString() : responseData.get(key).toString();
            result = result.replace(placeholder, value);
        }
        return result;
    }
}

