/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.kafka.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.logging.kafka.client.KafkaLogCollectClient;
import org.apache.shenyu.plugin.logging.kafka.collector.KafkaLogCollector;
import org.apache.shenyu.plugin.logging.kafka.config.KafkaLogCollectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingKafkaPluginDataHandler
implements PluginDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingKafkaPluginDataHandler.class);
    private static final KafkaLogCollectClient KAFKA_LOG_COLLECT_CLIENT = new KafkaLogCollectClient();
    private static final String EMPTY_JSON = "{}";
    private static final Map<String, List<String>> SELECT_ID_URI_LIST_MAP = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, KafkaLogCollectConfig.LogApiConfig> SELECT_API_CONFIG_MAP = new ConcurrentHashMap<String, KafkaLogCollectConfig.LogApiConfig>();

    public static KafkaLogCollectClient getKafkaLogCollectClient() {
        return KAFKA_LOG_COLLECT_CLIENT;
    }

    public static Map<String, List<String>> getSelectIdUriListMap() {
        return SELECT_ID_URI_LIST_MAP;
    }

    public static Map<String, KafkaLogCollectConfig.LogApiConfig> getSelectApiConfigMap() {
        return SELECT_API_CONFIG_MAP;
    }

    public void handlerPlugin(PluginData pluginData) {
        LOG.info("handler loggingKafka Plugin data:{}", (Object)GsonUtils.getGson().toJson((Object)pluginData));
        if (pluginData.getEnabled().booleanValue()) {
            KafkaLogCollectConfig.KafkaLogConfig globalLogConfig = (KafkaLogCollectConfig.KafkaLogConfig)((Object)GsonUtils.getInstance().fromJson(pluginData.getConfig(), KafkaLogCollectConfig.KafkaLogConfig.class));
            KafkaLogCollectConfig.INSTANCE.setKafkaLogConfig(globalLogConfig);
            Properties properties = new Properties();
            properties.put("key.serializer", StringSerializer.class.getName());
            properties.put("value.serializer", StringSerializer.class.getName());
            properties.put("bootstrap.servers", globalLogConfig.getNamesrvAddr());
            properties.put("Topic", globalLogConfig.getTopic());
            properties.put("namesrvAddr", globalLogConfig.getTopic());
            KAFKA_LOG_COLLECT_CLIENT.initProducer(properties);
            KafkaLogCollector.getInstance().start();
        } else {
            try {
                KafkaLogCollector.getInstance().close();
            }
            catch (Exception e) {
                LOG.error("close log collector error", (Throwable)e);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        LOG.info("handler loggingKafka selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        String handleJson = selectorData.getHandle();
        if (StringUtils.isEmpty((CharSequence)handleJson) || EMPTY_JSON.equals(handleJson.trim())) {
            return;
        }
        if (selectorData.getType().intValue() != SelectorTypeEnum.CUSTOM_FLOW.getCode() || CollectionUtils.isEmpty((Collection)selectorData.getConditionList())) {
            return;
        }
        KafkaLogCollectConfig.LogApiConfig logApiConfig = (KafkaLogCollectConfig.LogApiConfig)GsonUtils.getInstance().fromJson(handleJson, KafkaLogCollectConfig.LogApiConfig.class);
        if (StringUtils.isBlank((CharSequence)logApiConfig.getTopic()) || StringUtils.isBlank((CharSequence)logApiConfig.getSampleRate())) {
            return;
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (ConditionData conditionData : selectorData.getConditionList()) {
            if (!"uri".equals(conditionData.getParamType()) || !StringUtils.isNotBlank((CharSequence)conditionData.getParamValue()) || !"match".equals(conditionData.getOperator()) && !"=".equals(conditionData.getOperator())) continue;
            uriList.add(conditionData.getParamValue().trim());
        }
        SELECT_ID_URI_LIST_MAP.put(selectorData.getId(), uriList);
        SELECT_API_CONFIG_MAP.put(selectorData.getId(), logApiConfig);
    }

    public void removeSelector(SelectorData selectorData) {
        LOG.info("handler remove loggingKafka selector data:{}", (Object)GsonUtils.getGson().toJson((Object)selectorData));
        SELECT_ID_URI_LIST_MAP.remove(selectorData.getId());
        SELECT_API_CONFIG_MAP.remove(selectorData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_KAFKA.getName();
    }
}

