/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.kafka.client;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.common.client.LogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.LZ4CompressData;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.kafka.config.KafkaLogCollectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaLogCollectClient
implements LogConsumeClient {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaLogCollectClient.class);
    private static Map<String, String> apiTopicMap = new HashMap<String, String>();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private KafkaProducer<String, String> producer;
    private String topic;

    public void initProducer(Properties props) {
        if (MapUtils.isEmpty((Map)props)) {
            LOG.error("kafka props is empty. failed init kafka producer");
            return;
        }
        if (this.isStarted.get()) {
            this.close();
        }
        String topic = props.getProperty("Topic");
        String nameserverAddress = props.getProperty("bootstrap.servers");
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)nameserverAddress)) {
            LOG.error("init kafkaLogCollectClient error, please check topic or nameserverAddress");
            return;
        }
        this.topic = topic;
        this.producer = new KafkaProducer(props);
        ProducerRecord record = new ProducerRecord(this.topic, (Object)"shenyu-access-logging");
        try {
            this.producer.send(record);
            LOG.info("init kafkaLogCollectClient success");
            this.isStarted.set(true);
        }
        catch (AuthorizationException | OutOfOrderSequenceException | ProducerFencedException e) {
            LOG.error("Init kafkaLogCollectClient error, We can't recover from these exceptions, so our only option is to close the producer and exit", e);
            this.producer.close();
        }
        catch (KafkaException e) {
            LOG.error("init kafkaLogCollectClient error\uff0cExceptions other than ProducerFencedException or OutOfOrderSequenceException or AuthorizationException, just abort the transaction and try again", (Throwable)e);
        }
    }

    public void consume(List<ShenyuRequestLog> logs) {
        if (CollectionUtils.isEmpty(logs) || !this.isStarted.get()) {
            return;
        }
        logs.forEach(log -> {
            String logTopic = (String)StringUtils.defaultIfBlank((CharSequence)LogCollectConfigUtils.getTopic((String)log.getPath(), apiTopicMap), (CharSequence)this.topic);
            try {
                this.producer.send(this.toProducerRecord(logTopic, (ShenyuRequestLog)log));
            }
            catch (Exception e) {
                LOG.error("kafka push logs error", (Throwable)e);
            }
        });
    }

    private ProducerRecord<String, String> toProducerRecord(String logTopic, ShenyuRequestLog log) {
        byte[] bytes = JsonUtils.toJson((Object)log).getBytes(StandardCharsets.UTF_8);
        String compressAlg = (String)StringUtils.defaultIfBlank((CharSequence)KafkaLogCollectConfig.INSTANCE.getKafkaLogConfig().getCompressAlg(), (CharSequence)"");
        if ("LZ4".equalsIgnoreCase(compressAlg.trim())) {
            LZ4CompressData lz4CompressData = new LZ4CompressData(bytes.length, this.compressedByte(bytes));
            return new ProducerRecord(logTopic, (Object)JsonUtils.toJson((Object)lz4CompressData));
        }
        return new ProducerRecord(logTopic, (Object)JsonUtils.toJson((Object)log));
    }

    private byte[] compressedByte(byte[] srcByte) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        return compressor.compress(srcByte);
    }

    public static void setTopic(Map<String, String> uriTopicMap) {
        apiTopicMap = uriTopicMap;
    }

    public void close() {
        if (Objects.nonNull(this.producer) && this.isStarted.get()) {
            this.producer.close();
            this.isStarted.set(false);
        }
    }
}

