/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt.strategy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.jwt.rule.DefaultJwtRuleHandle;
import org.apache.shenyu.plugin.jwt.rule.JwtRuleHandle;
import org.apache.shenyu.plugin.jwt.strategy.JwtConvertStrategy;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

@Join
public class DefaultJwtConvertStrategy
implements JwtConvertStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtConvertStrategy.class);

    @Override
    public DefaultJwtRuleHandle parseHandleJson(String handleJson) {
        try {
            return (DefaultJwtRuleHandle)GsonUtils.getInstance().fromJson(handleJson, DefaultJwtRuleHandle.class);
        }
        catch (Exception exception) {
            LOG.error("Failed to parse json , please check json format", (Throwable)exception);
            return null;
        }
    }

    @Override
    public ServerWebExchange convert(JwtRuleHandle jwtRuleHandle, ServerWebExchange exchange, Map<String, Object> jwtBody) {
        DefaultJwtRuleHandle defaultJwtRuleHandle = (DefaultJwtRuleHandle)jwtRuleHandle;
        if (CollectionUtils.isEmpty(defaultJwtRuleHandle.getConverter())) {
            return exchange;
        }
        return this.convert(exchange, jwtBody, defaultJwtRuleHandle.getConverter());
    }

    private ServerWebExchange convert(ServerWebExchange exchange, Map<String, Object> jwtBody, List<DefaultJwtRuleHandle.Convert> converters) {
        ServerHttpRequest modifiedRequest = exchange.getRequest().mutate().headers(httpHeaders -> this.addHeader((HttpHeaders)httpHeaders, jwtBody, converters)).build();
        return exchange.mutate().request(modifiedRequest).build();
    }

    private void addHeader(HttpHeaders headers, Map<String, Object> body, List<DefaultJwtRuleHandle.Convert> converters) {
        for (DefaultJwtRuleHandle.Convert converter : converters) {
            if (StringUtils.isEmpty((CharSequence)converter.getHeaderVal()) || StringUtils.isEmpty((CharSequence)converter.getJwtVal())) continue;
            if (converter.getJwtVal().contains(".")) {
                headers.add(converter.getHeaderVal(), this.parse(body, converter.getJwtVal().split("\\."), new AtomicInteger(0)));
            }
            headers.add(converter.getHeaderVal(), String.valueOf(body.get(converter.getJwtVal())));
        }
    }

    private String parse(Map<String, Object> body, String[] split, AtomicInteger deep) {
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            if (deep.get() == split.length - 1) {
                return String.valueOf(body.get(split[deep.get()]));
            }
            if (!entry.getKey().equals(split[deep.get()]) || !(entry.getValue() instanceof Map)) continue;
            deep.incrementAndGet();
            return this.parse((Map)entry.getValue(), split, deep);
        }
        return String.valueOf(body.get(split[deep.get()]));
    }
}

