/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.alert;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.AlarmContent;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.alert.AlarmService;
import org.apache.shenyu.plugin.base.alert.AlarmThreadPoolExecutor;

public class AlarmSender {
    private static AlarmService alarmService;
    private static Boolean enabled;
    private static String namespaceId;

    public static void alarm(AlarmContent alarmContent) {
        ShenyuConfig shenyuConfig;
        if (StringUtils.isNotEmpty((CharSequence)alarmContent.getNamespaceId())) {
            shenyuConfig = (ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class);
            namespaceId = shenyuConfig.getNamespace();
            alarmContent.setNamespaceId(namespaceId);
        }
        if (alarmService == null) {
            alarmService = (AlarmService)SpringBeanUtils.getInstance().getBean(AlarmService.class);
        }
        if (enabled == null) {
            shenyuConfig = (ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class);
            enabled = shenyuConfig.getAlert().getEnabled();
        }
        AlarmThreadPoolExecutor.getInstance().execute(() -> alarmService.alarm(alarmContent));
    }

    public static void alarm(byte level, String title, String content, Map<String, String> labels) {
        AlarmContent alarmContent = new AlarmContent.Builder().level(level).title(title).content(content).labels(labels).namespaceId(namespaceId).dateCreated(new Date()).build();
        AlarmSender.alarm(alarmContent);
    }

    public static void alarm(byte level, String title, String content) {
        AlarmContent alarmContent = new AlarmContent.Builder().level(level).title(title).content(content).namespaceId(namespaceId).dateCreated(new Date()).build();
        AlarmSender.alarm(alarmContent);
    }

    public static void alarmHighEmergency(String title, String content, Map<String, String> labels) {
        AlarmContent alarmContent = new AlarmContent.Builder().level((byte)0).title(title).content(content).labels(labels).namespaceId(namespaceId).dateCreated(new Date()).build();
        AlarmSender.alarm(alarmContent);
    }

    public static void alarmMediumCritical(String title, String content, Map<String, String> labels) {
        AlarmContent alarmContent = new AlarmContent.Builder().level((byte)1).title(title).content(content).labels(labels).namespaceId(namespaceId).dateCreated(new Date()).build();
        AlarmSender.alarm(alarmContent);
    }

    public static void alarmLowWarning(String title, String content, Map<String, String> labels) {
        AlarmContent alarmContent = new AlarmContent.Builder().level((byte)2).title(title).content(content).labels(labels).namespaceId(namespaceId).dateCreated(new Date()).build();
        AlarmSender.alarm(alarmContent);
    }
}

