/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.shenyu.plugin.api.HandleCache;

public class CommonHandleCache<K, V>
implements HandleCache<K, V> {
    private final ConcurrentHashMap<K, V> cached = new ConcurrentHashMap();

    public V obtainHandle(K key, Supplier<V> supplier) {
        return this.cached.getOrDefault(key, supplier.get());
    }

    public V obtainHandle(K key) {
        return this.cached.get(key);
    }

    public void cachedHandle(K key, V value) {
        Optional.ofNullable(key).ifPresent(data -> this.cached.put(key, value));
    }

    public void removeHandle(K key) {
        Optional.ofNullable(key).ifPresent(this.cached::remove);
    }

    public ConcurrentHashMap<K, V> getAllCache() {
        return this.cached;
    }
}

