/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;

public final class ChatClientCache {
    private static final Logger LOG = LoggerFactory.getLogger(ChatClientCache.class);
    private final Map<String, ChatClient> chatClientMap = new ConcurrentHashMap<String, ChatClient>();

    public ChatClient computeIfAbsent(String key, Supplier<ChatModel> chatModelSupplier) {
        return this.chatClientMap.computeIfAbsent(key, (? super K k) -> ChatClient.builder((ChatModel)((ChatModel)chatModelSupplier.get())).build());
    }

    public void remove(String selectorId) {
        if (Objects.isNull(selectorId)) {
            return;
        }
        String prefix = selectorId + "|";
        this.chatClientMap.keySet().removeIf(k -> k.equals(selectorId) || k.startsWith(prefix));
        LOG.info("[ChatClientCache] invalidate selectorId={} (by prefix)", (Object)selectorId);
    }

    public void clearAll() {
        this.chatClientMap.clear();
        LOG.info("[ChatClientCache] cleared all cached clients");
    }

    public void put(String key, ChatClient client) {
        this.chatClientMap.put(key, client);
    }
}

