/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class LeastActiveLoadBalance
extends AbstractLoadBalancer {
    private final Map<String, Long> countMap = new ConcurrentHashMap<String, Long>();

    @Override
    protected Upstream doSelect(List<Upstream> upstreamList, String ip) {
        Map domainMap = upstreamList.stream().collect(Collectors.toConcurrentMap(Upstream::buildDomain, upstream -> upstream));
        domainMap.keySet().stream().filter(key -> !this.countMap.containsKey(key)).forEach(domain -> this.countMap.put((String)domain, Long.MIN_VALUE));
        String domain2 = this.countMap.entrySet().stream().filter(entry -> domainMap.containsKey(entry.getKey())).min(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(upstreamList.get(0).buildDomain());
        this.countMap.computeIfPresent(domain2, (key, actived) -> Optional.of(actived).orElse(Long.MIN_VALUE) + 1L);
        return (Upstream)domainMap.get(domain2);
    }
}

