/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.cache;

import com.google.common.collect.Maps;
import io.kubernetes.client.openapi.models.V1Ingress;
import java.util.Map;
import org.apache.shenyu.k8s.cache.K8sResourceCache;

public final class IngressCache
implements K8sResourceCache<V1Ingress> {
    private static final IngressCache INSTANCE = new IngressCache();
    private static final Map<String, V1Ingress> INGRESS_MAP = Maps.newConcurrentMap();

    private IngressCache() {
    }

    public static IngressCache getInstance() {
        return INSTANCE;
    }

    @Override
    public void put(String namespace, String name, V1Ingress resource) {
        INGRESS_MAP.put(this.getKey(namespace, name), resource);
    }

    @Override
    public V1Ingress get(String namespace, String name) {
        return INGRESS_MAP.get(this.getKey(namespace, name));
    }

    @Override
    public V1Ingress remove(String namespace, String name) {
        return INGRESS_MAP.remove(this.getKey(namespace, name));
    }

    private String getKey(String namespace, String name) {
        return String.format("%s-%s", namespace, name);
    }
}

