/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.concurrent.EagerExecutorService;

public interface TaskQueue<E>
extends BlockingQueue<E> {
    public EagerExecutorService getExecutor();

    public void setExecutor(EagerExecutorService var1);

    @Override
    default public boolean offer(E e) {
        if (Objects.isNull(this.getExecutor())) {
            throw new RejectedExecutionException("The task queue does not have executor!");
        }
        int currentPoolThreadSize = this.getExecutor().getPoolSize();
        if (this.getExecutor().getActiveCount() < currentPoolThreadSize) {
            return this.doOffer(e);
        }
        if (currentPoolThreadSize < this.getExecutor().getMaximumPoolSize()) {
            return false;
        }
        return this.doOffer(e);
    }

    public boolean doOffer(E var1);

    default public boolean retryOffer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getExecutor().isShutdown()) {
            throw new RejectedExecutionException("Executor is shutdown!");
        }
        return this.offer(o, timeout, unit);
    }
}

