/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.spring.websocket.init;

import jakarta.servlet.ServletContext;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.Objects;
import org.apache.shenyu.client.spring.websocket.annotation.ShenyuServerEndpoint;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class ShenyuServerEndpointerExporter
extends WebApplicationObjectSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuServerEndpointerExporter.class);
    @Nullable
    private ServerContainer serverContainer;

    public void setServerContainer(@Nullable ServerContainer serverContainer) {
        this.serverContainer = serverContainer;
    }

    @Nullable
    protected ServerContainer getServerContainer() {
        return this.serverContainer;
    }

    protected void initServletContext(ServletContext servletContext) {
        if (Objects.isNull(this.serverContainer)) {
            this.serverContainer = (ServerContainer)servletContext.getAttribute("jakarta.websocket.server.ServerContainer");
        }
    }

    protected boolean isContextRequired() {
        return false;
    }

    public void registerEndpoint(Class<?> pojo) {
        ShenyuServerEndpoint annotation = (ShenyuServerEndpoint)AnnotatedElementUtils.findMergedAnnotation(pojo, ShenyuServerEndpoint.class);
        if (Objects.isNull(annotation)) {
            throw new ShenyuException("Class missing annotation ShenyuServerEndpoint! class name: " + pojo.getName());
        }
        String path = annotation.value();
        Class<? extends ServerEndpointConfig.Configurator> configuratorClazz = annotation.configurator();
        ServerEndpointConfig.Configurator configurator = null;
        if (!configuratorClazz.equals(ServerEndpointConfig.Configurator.class)) {
            try {
                configurator = annotation.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                LOG.error("ShenyuServerEndpoint configurator init fail! Class name: {}, configurator name: {}", (Object)pojo.getName(), (Object)annotation.configurator().getName());
                throw new ShenyuException((Throwable)ex);
            }
        }
        ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(pojo, (String)path).decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).subprotocols(Arrays.asList(annotation.subprotocols())).configurator(configurator).build();
        this.registerEndpoint(sec);
    }

    private void registerEndpoint(ServerEndpointConfig endpointConfig) {
        ServerContainer serverContainer = this.getServerContainer();
        Assert.state((boolean)Objects.nonNull(serverContainer), (String)"No ServerContainer set");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering ServerEndpointConfig: " + endpointConfig));
            }
            serverContainer.addEndpoint(endpointConfig);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register ServerEndpointConfig: " + endpointConfig, ex);
        }
    }
}

