/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.mcp.common.eunm;

import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Objects;

public enum McpParameterType {
    STRING("string"),
    INTEGER("integer"),
    LONG("long"),
    DOUBLE("double"),
    FLOAT("float"),
    BOOLEAN("boolean"),
    OBJECT("object"),
    ARRAY("array");

    private final String typeName;

    private McpParameterType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static McpParameterType fromParameter(Parameter parameter) {
        if (Objects.isNull(parameter)) {
            return null;
        }
        Class<?> clazz = parameter.getType();
        if (clazz == String.class) {
            return STRING;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return INTEGER;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return FLOAT;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            return ARRAY;
        }
        if (clazz == Object.class) {
            return OBJECT;
        }
        return OBJECT;
    }
}

