/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc;

import com.google.common.collect.Lists;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.grpc.common.annotation.ShenyuGrpcClient;
import org.apache.shenyu.client.grpc.common.dto.GrpcExt;
import org.apache.shenyu.client.grpc.json.JsonServerServiceInterceptor;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class GrpcClientEventListener
extends AbstractContextRefreshedEventListener<BindableService, ShenyuGrpcClient> {
    private final List<ServerServiceDefinition> serviceDefinitions = Lists.newArrayList();

    public GrpcClientEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getContextPath(), this.getIpAndPort(), this.getPort()})) {
            throw new ShenyuClientIllegalArgumentException("grpc client must config the contextPath, ipAndPort");
        }
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, BindableService> beans) {
        ShenyuGrpcClient shenyuGrpcClient = (ShenyuGrpcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuGrpcClient.class);
        if (Objects.isNull(shenyuGrpcClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuGrpcClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.GRPC, (Object)version);
    }

    protected void handle(String beanName, BindableService bean) {
        this.exportJsonGenericService(bean);
        super.handle(beanName, (Object)bean);
    }

    protected Map<String, BindableService> getBeans(ApplicationContext context) {
        return context.getBeansOfType(BindableService.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, BindableService> beans, String namespaceId) {
        return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getIpAndPort()).rpcType(RpcTypeEnum.GRPC.getName()).eventType(EventType.REGISTER).host(super.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).namespaceId(namespaceId).build();
    }

    protected String getClientName() {
        return RpcTypeEnum.GRPC.getName();
    }

    protected String buildApiSuperPath(Class<?> clazz, ShenyuGrpcClient beanShenyuClient) {
        if (Objects.nonNull(beanShenyuClient) && !StringUtils.isBlank((CharSequence)beanShenyuClient.path())) {
            return beanShenyuClient.path();
        }
        return "";
    }

    protected Class<ShenyuGrpcClient> getAnnotationType() {
        return ShenyuGrpcClient.class;
    }

    protected String buildApiPath(Method method, String superPath, @Nullable ShenyuGrpcClient methodShenyuClient) {
        String contextPath = this.getContextPath();
        return superPath.contains("*") ? this.pathJoin(new String[]{contextPath, superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{contextPath, superPath, Objects.requireNonNull(methodShenyuClient).path()});
    }

    protected void handleClass(Class<?> clazz, BindableService bean, @NonNull ShenyuGrpcClient beanShenyuClient, String superPath) {
        Method[] methods = ReflectionUtils.getDeclaredMethods(clazz);
        List namespaceIds = super.getNamespace();
        for (String namespaceId : namespaceIds) {
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, beanShenyuClient, this.buildApiPath(method, superPath, null), clazz, method, namespaceId);
                this.getPublisher().publishEvent((DataTypeParent)metaData);
                this.getMetaDataMap().put(method, metaData);
            }
        }
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(BindableService bean, @NonNull ShenyuGrpcClient shenyuClient, String path, Class<?> clazz, Method method, String namespaceId) {
        String desc = shenyuClient.desc();
        String configRuleName = shenyuClient.ruleName();
        String ruleName = (String)StringUtils.defaultIfBlank((CharSequence)configRuleName, (CharSequence)path);
        String methodName = method.getName();
        String packageName = this.buildPackageName(clazz);
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        MethodDescriptor.MethodType methodType = JsonServerServiceInterceptor.getMethodTypeMap().get(packageName + "/" + methodName);
        return MetaDataRegisterDTO.builder().appName(this.getIpAndPort()).serviceName(packageName).methodName(methodName).contextPath(this.getContextPath()).host(super.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.GRPC.getName()).rpcExt(this.buildRpcExt(shenyuClient, methodType)).enabled(shenyuClient.enabled()).namespaceId(namespaceId).build();
    }

    private String buildPackageName(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        Class<?> classes = parent.getDeclaringClass();
        String packageName = null;
        try {
            String serviceName = "SERVICE_NAME";
            Field field = classes.getField(serviceName);
            field.setAccessible(true);
            packageName = field.get(null).toString();
        }
        catch (Exception e) {
            LOG.error(String.format("SERVICE_NAME field not found: %s", classes), (Throwable)e);
        }
        return packageName;
    }

    private String buildRpcExt(ShenyuGrpcClient shenyuGrpcClient, MethodDescriptor.MethodType methodType) {
        GrpcExt build = GrpcExt.builder().timeout(shenyuGrpcClient.timeout()).methodType(methodType).build();
        return GsonUtils.getInstance().toJson((Object)build);
    }

    private void exportJsonGenericService(BindableService bindableService) {
        ServerServiceDefinition serviceDefinition = bindableService.bindService();
        try {
            ServerServiceDefinition jsonDefinition = JsonServerServiceInterceptor.useJsonMessages(serviceDefinition);
            this.serviceDefinitions.add(serviceDefinition);
            this.serviceDefinitions.add(jsonDefinition);
        }
        catch (Exception e) {
            LOG.error("export json generic service is fail", (Throwable)e);
        }
    }

    public List<ServerServiceDefinition> getServiceDefinitions() {
        return this.serviceDefinitions;
    }
}

