/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc.json;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonForwardingServerCall<R, P>
extends ServerCall<R, P> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonForwardingServerCall.class);
    private final ServerCall<P, P> call;

    public JsonForwardingServerCall(ServerCall<P, P> call) {
        this.call = call;
    }

    protected ServerCall<P, P> delegate() {
        return this.call;
    }

    public void sendMessage(P message) {
        try {
            if (message == null) {
                this.delegate().sendMessage(null);
                return;
            }
            String jsonFormat = JsonFormat.printer().includingDefaultValueFields().preservingProtoFieldNames().print((MessageOrBuilder)message);
            DynamicMessage respMessage = JsonMessage.buildJsonMessage((String)jsonFormat);
            LOG.debug("begin send json response");
            this.delegate().sendMessage((Object)respMessage);
        }
        catch (InvalidProtocolBufferException e) {
            throw Status.INTERNAL.withDescription(e.getMessage()).asRuntimeException();
        }
    }

    public void request(int numMessages) {
        this.delegate().request(numMessages);
    }

    public void sendHeaders(Metadata headers) {
        this.delegate().sendHeaders(headers);
    }

    public boolean isReady() {
        return this.delegate().isReady();
    }

    public void close(Status status, Metadata trailers) {
        this.delegate().close(status, trailers);
    }

    public boolean isCancelled() {
        return this.delegate().isCancelled();
    }

    public void setMessageCompression(boolean enabled) {
        this.delegate().setMessageCompression(enabled);
    }

    public void setCompression(String compressor) {
        this.delegate().setCompression(compressor);
    }

    public Attributes getAttributes() {
        return this.delegate().getAttributes();
    }

    public MethodDescriptor<R, P> getMethodDescriptor() {
        return this.delegate().getMethodDescriptor();
    }
}

