/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class GrpcContextRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final String ipAndPort;
    private final String host;
    private final int port;
    private final String contextPath;

    public GrpcContextRefreshedEventListener(PropertiesConfig config) {
        Properties props = config.getProps();
        String contextPath = props.getProperty("contextPath");
        String ipAndPort = props.getProperty("ipAndPort");
        String port = props.getProperty("port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{contextPath, ipAndPort, port})) {
            throw new ShenyuClientIllegalArgumentException("grpc client must config the contextPath, ipAndPort, port");
        }
        this.ipAndPort = ipAndPort;
        this.contextPath = contextPath;
        this.host = props.getProperty("host");
        this.port = Integer.parseInt(port);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO());
    }

    private URIRegisterDTO buildURIRegisterDTO() {
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.ipAndPort).rpcType(RpcTypeEnum.GRPC.getName()).host(host).port(Integer.valueOf(this.port)).build();
    }
}

