/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc.json;

import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.client.grpc.json.JsonForwardingServerCall;
import org.apache.shenyu.client.grpc.json.JsonServerCallListener;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ReflectUtils;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;

public class JsonServerServiceInterceptor {
    private static Map<String, Class<?>> requestClazzMap = Maps.newConcurrentMap();
    private static Map<String, MethodDescriptor.MethodType> methodTypeMap = Maps.newConcurrentMap();

    public static ServerServiceDefinition useJsonMessages(ServerServiceDefinition serviceDef) throws IllegalArgumentException, IllegalAccessException {
        return JsonServerServiceInterceptor.useMarshalledMessages(serviceDef, ProtoUtils.marshaller((Message)JsonMessage.buildJsonMessage()));
    }

    public static <T> ServerServiceDefinition useMarshalledMessages(ServerServiceDefinition serviceDef, MethodDescriptor.Marshaller<T> marshaller) throws IllegalArgumentException, IllegalAccessException {
        String fullMethodName;
        ArrayList wrappedMethods = new ArrayList();
        ArrayList<MethodDescriptor> wrappedDescriptors = new ArrayList<MethodDescriptor>();
        for (Object definition : serviceDef.getMethods()) {
            MethodDescriptor.Marshaller requestMarshaller = definition.getMethodDescriptor().getRequestMarshaller();
            Field field = ReflectUtils.getField(requestMarshaller.getClass(), (String)"defaultInstance");
            if (Objects.isNull(field)) {
                throw new ShenyuException(String.format("can not get defaultInstance Field of %s", requestMarshaller.getClass()));
            }
            field.setAccessible(true);
            fullMethodName = definition.getMethodDescriptor().getFullMethodName();
            MethodDescriptor.MethodType methodType = definition.getMethodDescriptor().getType();
            methodTypeMap.put(fullMethodName, methodType);
            String[] splitMethodName = fullMethodName.split("/");
            fullMethodName = splitMethodName[0] + "JSON" + "/" + splitMethodName[1];
            requestClazzMap.put(fullMethodName, field.get(requestMarshaller).getClass());
            MethodDescriptor originalMethodDescriptor = definition.getMethodDescriptor();
            MethodDescriptor wrappedMethodDescriptor = originalMethodDescriptor.toBuilder(marshaller, marshaller).build();
            wrappedDescriptors.add(wrappedMethodDescriptor);
            wrappedMethods.add(JsonServerServiceInterceptor.wrapMethod(definition, wrappedMethodDescriptor));
        }
        ServiceDescriptor.Builder build = ServiceDescriptor.newBuilder((String)(serviceDef.getServiceDescriptor().getName() + "JSON"));
        for (MethodDescriptor md : wrappedDescriptors) {
            Field field = ReflectUtils.getField(md.getClass(), (String)"fullMethodName");
            if (Objects.isNull(field)) {
                throw new ShenyuException(String.format("can not get fullMethodName Field of %s", md.getClass()));
            }
            field.setAccessible(true);
            fullMethodName = (String)field.get(md);
            String[] splitMethodName = fullMethodName.split("/");
            fullMethodName = splitMethodName[0] + "JSON" + "/" + splitMethodName[1];
            field.set(md, fullMethodName);
            Field serviceNameField = ReflectUtils.getField(md.getClass(), (String)"serviceName");
            if (Objects.isNull(serviceNameField)) {
                throw new ShenyuException(String.format("can not get serviceName Field Field of %s", md.getClass()));
            }
            serviceNameField.setAccessible(true);
            String serviceName = (String)serviceNameField.get(md);
            serviceName = serviceName + "JSON";
            serviceNameField.set(md, serviceName);
            build.addMethod(md);
        }
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)build.build());
        for (ServerMethodDefinition serverMethodDefinition : wrappedMethods) {
            serviceBuilder.addMethod(serverMethodDefinition);
        }
        return serviceBuilder.build();
    }

    private static <R, P, W, M> ServerMethodDefinition<W, M> wrapMethod(ServerMethodDefinition<R, P> definition, MethodDescriptor<W, M> wrappedMethod) {
        ServerCallHandler<W, M> wrappedHandler = JsonServerServiceInterceptor.wrapHandler(definition.getServerCallHandler());
        return ServerMethodDefinition.create(wrappedMethod, wrappedHandler);
    }

    private static <R, P, W, M> ServerCallHandler<W, M> wrapHandler(final ServerCallHandler<R, P> originalHandler) {
        return new ServerCallHandler<W, M>(){

            public ServerCall.Listener<W> startCall(ServerCall<W, M> call, Metadata headers) {
                JsonForwardingServerCall unwrappedCall = new JsonForwardingServerCall(call);
                ServerCall.Listener originalListener = originalHandler.startCall(unwrappedCall, headers);
                return new JsonServerCallListener(originalListener, unwrappedCall);
            }
        };
    }

    public static Map<String, Class<?>> getRequestClazzMap() {
        return requestClazzMap;
    }

    public static Map<String, MethodDescriptor.MethodType> getMethodTypeMap() {
        return methodTypeMap;
    }
}

