/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.grpc.common.annotation.ShenyuGrpcClient;
import org.apache.shenyu.client.grpc.common.dto.GrpcExt;
import org.apache.shenyu.client.grpc.json.JsonServerServiceInterceptor;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GrpcClientBeanPostProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcClientBeanPostProcessor.class);
    private ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final ExecutorService executorService;
    private final String contextPath;
    private final String ipAndPort;
    private final String host;
    private final int port;
    private List<ServerServiceDefinition> serviceDefinitions = Lists.newArrayList();

    public GrpcClientBeanPostProcessor(ShenyuRegisterCenterConfig config, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = config.getProps();
        String contextPath = props.getProperty("contextPath");
        String ipAndPort = props.getProperty("ipAndPort");
        String port = props.getProperty("port");
        if (StringUtils.isEmpty((Object)contextPath) || StringUtils.isEmpty((Object)ipAndPort) || StringUtils.isEmpty((Object)port)) {
            throw new RuntimeException("grpc client must config the contextPath, ipAndPort");
        }
        this.ipAndPort = ipAndPort;
        this.contextPath = contextPath;
        this.host = props.getProperty("host");
        this.port = Integer.parseInt(port);
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("shenyu-grpc-client-thread-pool-%d").build());
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (bean instanceof BindableService) {
            this.exportJsonGenericService(bean);
            this.executorService.execute(() -> this.handler(bean));
        }
        return bean;
    }

    private void handler(Object serviceBean) {
        Method[] methods;
        String packageName;
        Class<?> clazz;
        try {
            clazz = serviceBean.getClass();
        }
        catch (Exception e) {
            log.error("failed to get grpc target class");
            return;
        }
        Class<?> parent = clazz.getSuperclass();
        Class<?> classes = parent.getDeclaringClass();
        try {
            String serviceName = "SERVICE_NAME";
            Field field = classes.getField(serviceName);
            field.setAccessible(true);
            packageName = field.get(null).toString();
        }
        catch (Exception e) {
            log.error(String.format("SERVICE_NAME field not found: %s", classes));
            return;
        }
        if (StringUtils.isEmpty((Object)packageName)) {
            log.error(String.format("grpc SERVICE_NAME can not found: %s", classes));
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(clazz)) {
            ShenyuGrpcClient grpcClient = method.getAnnotation(ShenyuGrpcClient.class);
            if (!Objects.nonNull(grpcClient)) continue;
            this.publisher.publishEvent((Object)this.buildMetaDataDTO(packageName, grpcClient, method));
        }
    }

    private MetaDataRegisterDTO buildMetaDataDTO(String packageName, ShenyuGrpcClient shenyuGrpcClient, Method method) {
        String path = this.contextPath + shenyuGrpcClient.path();
        String desc = shenyuGrpcClient.desc();
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        String configRuleName = shenyuGrpcClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        MethodDescriptor.MethodType methodType = JsonServerServiceInterceptor.getMethodTypeMap().get(packageName + "/" + methodName);
        return MetaDataRegisterDTO.builder().appName(this.ipAndPort).serviceName(packageName).methodName(methodName).contextPath(this.contextPath).host(host).port(Integer.valueOf(this.port)).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType("grpc").rpcExt(this.buildRpcExt(shenyuGrpcClient, methodType)).enabled(shenyuGrpcClient.enabled()).build();
    }

    private String buildRpcExt(ShenyuGrpcClient shenyuGrpcClient, MethodDescriptor.MethodType methodType) {
        GrpcExt build = GrpcExt.builder().timeout(shenyuGrpcClient.timeout()).methodType(methodType).build();
        return GsonUtils.getInstance().toJson((Object)build);
    }

    private void exportJsonGenericService(Object bean) {
        BindableService bindableService = (BindableService)bean;
        ServerServiceDefinition serviceDefinition = bindableService.bindService();
        try {
            ServerServiceDefinition jsonDefinition = JsonServerServiceInterceptor.useJsonMessages(serviceDefinition);
            this.serviceDefinitions.add(serviceDefinition);
            this.serviceDefinitions.add(jsonDefinition);
        }
        catch (Exception e) {
            log.error("export json generic service is fail", (Throwable)e);
        }
    }

    @Generated
    public List<ServerServiceDefinition> getServiceDefinitions() {
        return this.serviceDefinitions;
    }
}

