/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.Response;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.model.dto.SwaggerImportRequest;
import org.apache.shenyu.admin.service.SwaggerImportService;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterMcpServiceImpl;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.admin.utils.UrlSecurityUtils;
import org.apache.shenyu.client.mcp.common.dto.ShenyuMcpRequestConfig;
import org.apache.shenyu.client.mcp.common.dto.ShenyuMcpTool;
import org.apache.shenyu.client.mcp.generator.McpToolsRegisterDTOGenerator;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.McpToolsRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SwaggerImportServiceImpl
implements SwaggerImportService {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerImportServiceImpl.class);
    private final DocManager docManager;
    private final HttpUtils httpUtils;
    @Resource
    private ShenyuClientRegisterMcpServiceImpl shenyuClientRegisterMcpService;

    public SwaggerImportServiceImpl(DocManager docManager, HttpUtils httpUtils) {
        this.docManager = docManager;
        this.httpUtils = httpUtils;
    }

    @Override
    public String importSwagger(SwaggerImportRequest request) {
        LOG.info("Start importing Swagger document: {}", (Object)request);
        try {
            this.validateSwaggerUrl(request.getSwaggerUrl());
            String swaggerJson = this.fetchSwaggerDoc(request.getSwaggerUrl());
            this.validateSwaggerContent(swaggerJson);
            UpstreamInstance instance = this.createVirtualInstance(request);
            this.docManager.addDocInfo(instance, swaggerJson, null, docInfo -> LOG.info("Successfully imported swagger document: {} with MD5: {}", (Object)request.getProjectName(), (Object)docInfo.getDocMd5()));
            return "Import successful, supports Swagger 2.0 and OpenAPI 3.0 formats";
        }
        catch (Exception e) {
            LOG.error("Failed to import swagger document: {}", (Object)request.getProjectName(), (Object)e);
            throw new RuntimeException("Import failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String importMcpConfig(SwaggerImportRequest request) {
        LOG.info("Start importing Mcp config: {}", (Object)request);
        try {
            this.validateSwaggerUrl(request.getSwaggerUrl());
            String swaggerJson = this.fetchSwaggerDoc(request.getSwaggerUrl());
            List<McpToolsRegisterDTO> mcpToolsRegisterDTOList = this.buildMcpToolRegisterDTO(swaggerJson, request.getNamespaceId());
            mcpToolsRegisterDTOList.forEach(mcpToolsRegisterDTO -> this.shenyuClientRegisterMcpService.registerMcpTools((McpToolsRegisterDTO)mcpToolsRegisterDTO));
            return "Import mcp server config successful, supports Swagger 2.0 and OpenAPI 3.0 formats";
        }
        catch (IOException e) {
            LOG.error("Failed to import mcp config: {}", (Object)request.getProjectName(), (Object)e);
            throw new RuntimeException("Import mcp server config failed: " + e.getMessage(), e);
        }
    }

    private List<McpToolsRegisterDTO> buildMcpToolRegisterDTO(String swaggerJson, String namespaceId) {
        ArrayList<McpToolsRegisterDTO> mcpToolsRegisterDTOList = new ArrayList<McpToolsRegisterDTO>();
        OpenAPI openapi = new OpenAPIV3Parser().readContents(swaggerJson, null, null).getOpenAPI();
        Map<String, List<Map<String, ShenyuMcpTool>>> mcpToolMap = this.buildShenyuMcpTool(openapi);
        JsonObject openApiJsonObject = JsonParser.parseString((String)swaggerJson).getAsJsonObject();
        mcpToolMap.forEach((selectorName, mcpToolList) -> mcpToolList.forEach(shenyuMcpToolMap -> shenyuMcpToolMap.forEach((url, shenyuMcpTool) -> {
            McpToolsRegisterDTO mcpToolsRegisterDTO = McpToolsRegisterDTOGenerator.generateRegisterDTO((ShenyuMcpTool)shenyuMcpTool, (JsonObject)openApiJsonObject, (String)url, (String)namespaceId);
            mcpToolsRegisterDTO.setMetaDataRegisterDTO(this.buildMetaDataRegisterDTO(openapi, (String)selectorName, (ShenyuMcpTool)shenyuMcpTool, (String)url, namespaceId));
            mcpToolsRegisterDTOList.add(mcpToolsRegisterDTO);
        })));
        return mcpToolsRegisterDTOList;
    }

    private Map<String, List<Map<String, ShenyuMcpTool>>> buildShenyuMcpTool(OpenAPI openapi) {
        if (Objects.isNull(openapi) || Objects.isNull(openapi.getPaths())) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, ShenyuMcpTool>>> result = new HashMap<String, List<Map<String, ShenyuMcpTool>>>();
        Paths paths = openapi.getPaths();
        for (Map.Entry entry : paths.entrySet()) {
            String fullPath = (String)entry.getKey();
            PathItem pathItem = (PathItem)entry.getValue();
            String[] segments = fullPath.split("/");
            String mainPath = Arrays.stream(segments).filter(s -> !s.isEmpty()).findFirst().orElse("default");
            List maps = result.computeIfAbsent(mainPath, k -> new ArrayList());
            HashMap<String, ShenyuMcpTool> toolMap = new HashMap<String, ShenyuMcpTool>();
            Map operationsMap = pathItem.readOperationsMap();
            for (Map.Entry opEntry : operationsMap.entrySet()) {
                Operation operation = (Operation)opEntry.getValue();
                ShenyuMcpTool tool = new ShenyuMcpTool();
                tool.setOperation(operation);
                ShenyuMcpRequestConfig shenyuMcpRequestConfig = new ShenyuMcpRequestConfig();
                shenyuMcpRequestConfig.setBodyToJson("false");
                tool.setRequestConfig(shenyuMcpRequestConfig);
                tool.setToolName(operation.getOperationId());
                tool.setEnable(Boolean.valueOf(true));
                PathItem.HttpMethod httpMethod = (PathItem.HttpMethod)opEntry.getKey();
                tool.setMethod(httpMethod.name().toLowerCase());
                toolMap.put(fullPath, tool);
            }
            maps.add(toolMap);
        }
        return result;
    }

    private MetaDataRegisterDTO buildMetaDataRegisterDTO(OpenAPI openapi, String selectorName, ShenyuMcpTool shenyuMcpTool, String contentPath, String namespaceId) {
        URL url;
        String urlString = ((Server)openapi.getServers().get(0)).getUrl();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error("url error");
            throw new RuntimeException(e);
        }
        String host = url.getHost();
        int port = url.getPort();
        Operation operation = shenyuMcpTool.getOperation();
        String parameterTypes = operation.getParameters().stream().map(Parameter::getIn).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(openapi.getInfo().getTitle()).serviceName(selectorName).methodName(shenyuMcpTool.getToolName()).contextPath(selectorName).path(contentPath).port(Integer.valueOf(port)).host(host).ruleName(shenyuMcpTool.getToolName()).pathDesc(operation.getDescription()).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.MCP.getName()).namespaceId(namespaceId).build();
    }

    @Override
    public boolean testConnection(String swaggerUrl) {
        boolean bl;
        block8: {
            this.validateSwaggerUrl(swaggerUrl);
            Response response = this.httpUtils.requestForResponse(swaggerUrl, Collections.emptyMap(), Collections.emptyMap(), HttpUtils.HTTPMethod.GET);
            try {
                boolean bl2 = bl = response.code() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Failed to test Swagger URL connection: {}", (Object)swaggerUrl, (Object)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private void validateSwaggerUrl(String swaggerUrl) {
        UrlSecurityUtils.validateUrlForSSRF(swaggerUrl);
    }

    private String fetchSwaggerDoc(String swaggerUrl) throws IOException {
        try (Response response = this.httpUtils.requestForResponse(swaggerUrl, Collections.emptyMap(), Collections.emptyMap(), HttpUtils.HTTPMethod.GET);){
            if (response.code() != 200) {
                throw new RuntimeException("Failed to get Swagger document, HTTP status code: " + response.code());
            }
            String string = response.body().string();
            return string;
        }
    }

    private void validateSwaggerContent(String swaggerJson) {
        try {
            boolean isV3;
            JsonObject docRoot = (JsonObject)GsonUtils.getInstance().fromJson(swaggerJson, JsonObject.class);
            boolean isV2 = docRoot.has("swagger") && docRoot.get("swagger").getAsString().startsWith("2.");
            boolean bl = isV3 = docRoot.has("openapi") && docRoot.get("openapi").getAsString().startsWith("3.");
            if (!isV2 && !isV3) {
                throw new IllegalArgumentException("Unsupported Swagger version, only Swagger 2.0 and OpenAPI 3.0 formats are supported");
            }
            LOG.info("Detected Swagger version: {}", (Object)(isV2 ? "2.0" : "3.0"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Swagger JSON format: " + e.getMessage());
        }
    }

    private UpstreamInstance createVirtualInstance(SwaggerImportRequest request) {
        UpstreamInstance instance = new UpstreamInstance();
        instance.setContextPath(request.getProjectName());
        try {
            URL url = new URL(request.getSwaggerUrl());
            instance.setIp(url.getHost());
            instance.setPort(url.getPort() == -1 ? (url.getProtocol().equals("https") ? 443 : 80) : url.getPort());
        }
        catch (Exception e) {
            instance.setIp("unknown");
            instance.setPort(80);
        }
        return instance;
    }
}

