/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class RuleDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final RuleService ruleService;

    public RuleDataConfigsExportImportHandler(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Rule;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<RuleVO> ruleDataList = this.ruleService.listAllDataByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            return Optional.of(JsonUtils.toJson(ruleDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List ruleList = GsonUtils.getInstance().fromList(data, RuleDTO.class);
        ConfigImportResult configImportResult = this.ruleService.importData(namespaceId, ruleList, context);
        context.getResult().put("ruleImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("ruleImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

