/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.rule;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class RuleChangedEvent
extends AdminDataModelChangedEvent {
    public RuleChangedEvent(RuleDO source, RuleDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        RuleDO after = (RuleDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the namespace [%s] rule [%s] is %s", after.getNamespaceId(), after.getRuleName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the namespace [%s] rule [%s] is %s : %s", after.getNamespaceId(), after.getRuleName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        RuleDO before = (RuleDO)this.getBefore();
        Objects.requireNonNull(before);
        RuleDO after = (RuleDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getRuleName(), after.getRuleName())) {
            builder.append(String.format("name[%s => %s] ", before.getRuleName(), after.getRuleName()));
        }
        if (!Objects.equals(before.getHandle(), after.getHandle())) {
            builder.append(String.format("handle[%s => %s] ", before.getHandle(), after.getHandle()));
        }
        if (!Objects.equals(before.getMatchMode(), after.getMatchMode())) {
            builder.append(String.format("match model[%s => %s] ", before.getMatchMode(), after.getMatchMode()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getSortCode(), after.getSortCode())) {
            builder.append(String.format("sort[%s => %s] ", before.getSortCode(), after.getSortCode()));
        }
        if (!Objects.equals(before.getLoged(), after.getLoged())) {
            builder.append(String.format("loged[%s => %s] ", before.getLoged(), after.getLoged()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "rule";
    }
}

