/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.handle.BatchPluginHandleChangedEvent;
import org.apache.shenyu.admin.model.event.handle.PluginHandleChangedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class PluginHandleEventPublisher
implements AdminDataModelChangedEventPublisher<PluginHandleDO> {
    private final ApplicationEventPublisher publisher;

    public PluginHandleEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(PluginHandleDO pluginHandle) {
        this.publish(new PluginHandleChangedEvent(pluginHandle, null, EventTypeEnum.PLUGIN_HANDLE_CREATE, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(PluginHandleDO pluginHandle, PluginHandleDO before) {
        this.publish(new PluginHandleChangedEvent(pluginHandle, before, EventTypeEnum.PLUGIN_HANDLE_UPDATE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(PluginHandleDO plugin) {
        this.publish(new PluginHandleChangedEvent(plugin, null, EventTypeEnum.PLUGIN_HANDLE_DELETE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<PluginHandleDO> plugins) {
        this.publish(new BatchPluginHandleChangedEvent(plugins, null, EventTypeEnum.PLUGIN_HANDLE_DELETE, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

