/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import okhttp3.Response;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.model.dto.SwaggerImportRequest;
import org.apache.shenyu.admin.service.SwaggerImportService;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.admin.utils.UrlSecurityUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SwaggerImportServiceImpl
implements SwaggerImportService {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerImportServiceImpl.class);
    private final DocManager docManager;
    private final HttpUtils httpUtils;

    public SwaggerImportServiceImpl(DocManager docManager, HttpUtils httpUtils) {
        this.docManager = docManager;
        this.httpUtils = httpUtils;
    }

    @Override
    public String importSwagger(SwaggerImportRequest request) {
        LOG.info("Start importing Swagger document: {}", (Object)request);
        try {
            this.validateSwaggerUrl(request.getSwaggerUrl());
            String swaggerJson = this.fetchSwaggerDoc(request.getSwaggerUrl());
            this.validateSwaggerContent(swaggerJson);
            UpstreamInstance instance = this.createVirtualInstance(request);
            this.docManager.addDocInfo(instance, swaggerJson, null, docInfo -> LOG.info("Successfully imported swagger document: {} with MD5: {}", (Object)request.getProjectName(), (Object)docInfo.getDocMd5()));
            return "Import successful, supports Swagger 2.0 and OpenAPI 3.0 formats";
        }
        catch (Exception e) {
            LOG.error("Failed to import swagger document: {}", (Object)request.getProjectName(), (Object)e);
            throw new RuntimeException("Import failed: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean testConnection(String swaggerUrl) {
        boolean bl;
        block8: {
            this.validateSwaggerUrl(swaggerUrl);
            Response response = this.httpUtils.requestForResponse(swaggerUrl, Collections.emptyMap(), Collections.emptyMap(), HttpUtils.HTTPMethod.GET);
            try {
                boolean bl2 = bl = response.code() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Failed to test Swagger URL connection: {}", (Object)swaggerUrl, (Object)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private void validateSwaggerUrl(String swaggerUrl) {
        UrlSecurityUtils.validateUrlForSSRF(swaggerUrl);
    }

    private String fetchSwaggerDoc(String swaggerUrl) throws IOException {
        try (Response response = this.httpUtils.requestForResponse(swaggerUrl, Collections.emptyMap(), Collections.emptyMap(), HttpUtils.HTTPMethod.GET);){
            if (response.code() != 200) {
                throw new RuntimeException("Failed to get Swagger document, HTTP status code: " + response.code());
            }
            String string = response.body().string();
            return string;
        }
    }

    private void validateSwaggerContent(String swaggerJson) {
        try {
            boolean isV3;
            JsonObject docRoot = (JsonObject)GsonUtils.getInstance().fromJson(swaggerJson, JsonObject.class);
            boolean isV2 = docRoot.has("swagger") && docRoot.get("swagger").getAsString().startsWith("2.");
            boolean bl = isV3 = docRoot.has("openapi") && docRoot.get("openapi").getAsString().startsWith("3.");
            if (!isV2 && !isV3) {
                throw new IllegalArgumentException("Unsupported Swagger version, only Swagger 2.0 and OpenAPI 3.0 formats are supported");
            }
            LOG.info("Detected Swagger version: {}", (Object)(isV2 ? "2.0" : "3.0"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Swagger JSON format: " + e.getMessage());
        }
    }

    private UpstreamInstance createVirtualInstance(SwaggerImportRequest request) {
        UpstreamInstance instance = new UpstreamInstance();
        instance.setContextPath(request.getProjectName());
        try {
            URL url = new URL(request.getSwaggerUrl());
            instance.setIp(url.getHost());
            instance.setPort(url.getPort() == -1 ? (url.getProtocol().equals("https") ? 443 : 80) : url.getPort());
        }
        catch (Exception e) {
            instance.setIp("unknown");
            instance.setPort(80);
        }
        return instance;
    }
}

