/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import org.apache.shenyu.admin.model.dto.SwaggerImportRequest;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.SwaggerImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swagger"})
@Validated
public class SwaggerImportController {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerImportController.class);
    private final SwaggerImportService swaggerImportService;

    public SwaggerImportController(SwaggerImportService swaggerImportService) {
        this.swaggerImportService = swaggerImportService;
    }

    @PostMapping(value={"/import"})
    public ShenyuAdminResult importSwagger(@Valid @RequestBody SwaggerImportRequest request) {
        LOG.info("Received Swagger import request: {}", (Object)request);
        try {
            String result = this.swaggerImportService.importSwagger(request);
            return ShenyuAdminResult.success(result);
        }
        catch (Exception e) {
            LOG.error("Failed to import swagger document", (Throwable)e);
            return ShenyuAdminResult.error("Import failed: " + e.getMessage());
        }
    }

    @PostMapping(value={"/test-connection"})
    public ShenyuAdminResult testConnection(@RequestParam String swaggerUrl) {
        LOG.info("Testing Swagger URL connection: {}", (Object)swaggerUrl);
        try {
            boolean isConnected = this.swaggerImportService.testConnection(swaggerUrl);
            return ShenyuAdminResult.success(isConnected ? "Connection successful" : "Connection failed");
        }
        catch (Exception e) {
            LOG.error("Failed to test connection", (Throwable)e);
            return ShenyuAdminResult.error("Connection failed: " + e.getMessage());
        }
    }
}

