/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.scaler;

import java.util.List;
import org.apache.shenyu.admin.mapper.ScalePolicyMapper;
import org.apache.shenyu.admin.mapper.ScaleRuleMapper;
import org.apache.shenyu.admin.model.entity.ScalePolicyDO;
import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.apache.shenyu.admin.scale.monitor.subject.cache.ScaleRuleCache;
import org.apache.shenyu.admin.scale.scaler.ScaleService;
import org.apache.shenyu.admin.scale.scaler.cache.ScalePolicyCache;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class ScaleTaskInitializer
implements CommandLineRunner {
    private final ScalePolicyMapper scalePolicyMapper;
    private final ScalePolicyCache scalePolicyCache;
    private final ScaleRuleMapper scaleRuleMapper;
    private final ScaleRuleCache scaleRuleCache;
    private final ScaleService scaleService;

    public ScaleTaskInitializer(ScalePolicyMapper scalePolicyMapper, ScalePolicyCache scalePolicyCache, ScaleService scaleService, ScaleRuleMapper scaleRuleMapper, ScaleRuleCache scaleRuleCache) {
        this.scalePolicyMapper = scalePolicyMapper;
        this.scalePolicyCache = scalePolicyCache;
        this.scaleService = scaleService;
        this.scaleRuleMapper = scaleRuleMapper;
        this.scaleRuleCache = scaleRuleCache;
    }

    public void run(String ... args) {
        List<ScalePolicyDO> policies = this.scalePolicyMapper.selectAll();
        this.scalePolicyCache.initialize(policies);
        List<ScaleRuleDO> rules = this.scaleRuleMapper.selectAll();
        this.scaleRuleCache.initialize(rules);
        this.scaleService.executeScaling();
    }
}

