/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.dto;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.admin.mapper.AppAuthMapper;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.model.dto.AuthParamDTO;
import org.apache.shenyu.admin.model.dto.AuthPathDTO;
import org.apache.shenyu.admin.validation.annotation.Existed;

public class AppAuthDTO
implements Serializable {
    private static final long serialVersionUID = 3906547569699874743L;
    @NotBlank(message="app auth id not null")
    @Existed(message="app auth is not existed", provider=AppAuthMapper.class)
    private @NotBlank(message="app auth id not null") @Existed(message="app auth is not existed", provider=AppAuthMapper.class) String id;
    @NotBlank(message="app auth appKey not null")
    private @NotBlank(message="app auth appKey not null") String appKey;
    @NotBlank(message="app auth appSecret not null")
    private @NotBlank(message="app auth appSecret not null") String appSecret;
    private String userId;
    @Pattern(regexp="\\+?\\d{7,11}", message="number is illegal, length 7 to 11! e.g. +1234567 or 1234567")
    private @Pattern(regexp="\\+?\\d{7,11}", message="number is illegal, length 7 to 11! e.g. +1234567 or 1234567") String phone;
    private String extInfo;
    private Boolean open;
    private Boolean enabled;
    @Valid
    private List<AuthParamDTO> authParamList;
    @Valid
    private List<AuthPathDTO> authPathList;
    @NotBlank
    @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class)
    private @NotBlank @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) String namespaceId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<AuthParamDTO> getAuthParamList() {
        return this.authParamList;
    }

    public void setAuthParamList(List<AuthParamDTO> authParamList) {
        this.authParamList = authParamList;
    }

    public List<AuthPathDTO> getAuthPathList() {
        return this.authPathList;
    }

    public void setAuthPathList(List<AuthPathDTO> authPathList) {
        this.authPathList = authPathList;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppAuthDTO)) {
            return false;
        }
        AppAuthDTO that = (AppAuthDTO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.appSecret, that.appSecret) && Objects.equals(this.userId, that.userId) && Objects.equals(this.phone, that.phone) && Objects.equals(this.extInfo, that.extInfo) && Objects.equals(this.open, that.open) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.authParamList, that.authParamList) && Objects.equals(this.authPathList, that.authPathList) && Objects.equals(this.namespaceId, that.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appKey, this.appSecret, this.userId, this.phone, this.extInfo, this.open, this.enabled, this.authParamList, this.authPathList, this.namespaceId);
    }
}

