/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.BatchNamespaceCommonDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageCondition;
import org.apache.shenyu.admin.model.query.RuleQueryCondition;
import org.apache.shenyu.admin.model.result.AdminResult;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/rule"})
public class RuleController
implements PagedController<RuleQueryCondition, RuleVO> {
    private final RuleService ruleService;

    public RuleController(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @GetMapping(value={""})
    public AdminResult<CommonPager<RuleVO>> queryRules(String selectorId, String name, @RequestParam @NotNull Integer currentPage, @RequestParam @NotNull Integer pageSize, @Valid @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) @Valid @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) String namespaceId) {
        RuleQueryCondition condition = new RuleQueryCondition();
        condition.setUserId(SessionUtil.visitor().getUserId());
        condition.setSelectors(ListUtil.of((Object[])new String[]{selectorId}));
        condition.setKeyword(name);
        condition.setNamespaceId(namespaceId);
        return this.searchAdaptor(new PageCondition<RuleQueryCondition>(currentPage, pageSize, condition));
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailRule(@Valid @PathVariable(value="id") @Existed(provider=RuleMapper.class, message="rule is not existed") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") String id) {
        RuleVO ruleVO = this.ruleService.findById(id);
        return ShenyuAdminResult.success("detail success", ruleVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createRule(@Valid @RequestBody RuleDTO ruleDTO) {
        Integer createCount = this.ruleService.createOrUpdate(ruleDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateRule(@PathVariable(value="id") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") @Valid @Existed(provider=RuleMapper.class, message="rule is not existed") String id, @Valid @RequestBody RuleDTO ruleDTO) {
        ruleDTO.setId(id);
        Integer updateCount = this.ruleService.createOrUpdate(ruleDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @PostMapping(value={"/batchEnabled"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        if (!this.ruleService.enabledByIdsAndNamespaceId(batchCommonDTO.getIds(), batchCommonDTO.getEnabled(), batchCommonDTO.getNamespaceId()).booleanValue()) {
            return ShenyuAdminResult.error("not found exception");
        }
        return ShenyuAdminResult.success("enable success");
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteRules(@Valid @RequestBody BatchNamespaceCommonDTO batchNamespaceCommonDTO) {
        Integer deleteCount = this.ruleService.deleteByIdsAndNamespaceId(batchNamespaceCommonDTO.getIds(), batchNamespaceCommonDTO.getNamespaceId());
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @Override
    public PageService<RuleQueryCondition, RuleVO> pageService() {
        return this.ruleService;
    }
}

