/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.ConfigsService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.multipart.MultipartFile;

@RestApi(value={"/configs"})
public class ConfigsExportImportController {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigsExportImportController.class);
    private final ConfigsService configsService;
    private final SyncDataService syncDataService;

    public ConfigsExportImportController(ConfigsService configsService, SyncDataService syncDataService) {
        this.configsService = configsService;
        this.syncDataService = syncDataService;
    }

    @GetMapping(value={"/export"})
    @RequiresPermissions(value={"system:manager:exportConfig"})
    public ResponseEntity<byte[]> exportConfigs(HttpServletResponse response) {
        ShenyuAdminResult result = this.configsService.configsExport();
        if (!Objects.equals(200, result.getCode())) {
            throw new ShenyuException(result.getMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        String fileName = this.generateFileName();
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)((byte[])result.getData()), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/exportByNamespace"})
    @RequiresPermissions(value={"system:manager:exportConfig"})
    public ResponseEntity<byte[]> exportConfigsByNamespace(String namespace, HttpServletResponse response) {
        ShenyuAdminResult result = this.configsService.configsExport(namespace);
        if (!Objects.equals(200, result.getCode())) {
            throw new ShenyuException(result.getMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        String fileName = this.generateFileName(namespace);
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)((byte[])result.getData()), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String generateFileName() {
        return "shenyu_config_export_" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
    }

    private String generateFileName(String namespace) {
        return "shenyu_config_export_" + namespace + "_" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".zip";
    }

    @PostMapping(value={"/import"})
    @RequiresPermissions(value={"system:manager:importConfig"})
    public ShenyuAdminResult importConfigs(String namespace, MultipartFile file) {
        if (StringUtils.isBlank((CharSequence)namespace) || Objects.isNull(file)) {
            return ShenyuAdminResult.error("parameter error");
        }
        try {
            ShenyuAdminResult importResult = this.configsService.configsImport(namespace, file.getBytes());
            if (Objects.equals(200, importResult.getCode())) {
                this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
            }
            return importResult;
        }
        catch (IOException e) {
            LOG.error("parsing data failed", (Throwable)e);
            return ShenyuAdminResult.error("parameter error");
        }
    }
}

