/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SubqueryExtractUtil {
    public static Collection<SubquerySegment> getSubquerySegments(SelectStatement selectStatement) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        SubqueryExtractUtil.extractSubquerySegments(result, selectStatement);
        return result;
    }

    private static void extractSubquerySegments(List<SubquerySegment> result, SelectStatement selectStatement) {
        SubqueryExtractUtil.extractSubquerySegmentsFromProjections(result, selectStatement.getProjections());
        SubqueryExtractUtil.extractSubquerySegmentsFromTableSegment(result, selectStatement.getFrom());
        if (selectStatement.getWhere().isPresent()) {
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, selectStatement.getWhere().get().getExpr());
        }
        selectStatement.getCombine().ifPresent(optional -> SubqueryExtractUtil.extractSubquerySegments(result, optional.getSelectStatement()));
    }

    private static void extractSubquerySegmentsFromProjections(List<SubquerySegment> result, ProjectionsSegment projections) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return;
        }
        for (ProjectionSegment each : projections.getProjections()) {
            if (!(each instanceof SubqueryProjectionSegment)) continue;
            SubquerySegment subquery = ((SubqueryProjectionSegment)each).getSubquery();
            subquery.setSubqueryType(SubqueryType.PROJECTION_SUBQUERY);
            result.add(subquery);
            SubqueryExtractUtil.extractSubquerySegments(result, subquery.getSelect());
        }
    }

    private static void extractSubquerySegmentsFromTableSegment(List<SubquerySegment> result, TableSegment tableSegment) {
        if (null == tableSegment) {
            return;
        }
        if (tableSegment instanceof SubqueryTableSegment) {
            SubquerySegment subquery = ((SubqueryTableSegment)tableSegment).getSubquery();
            subquery.setSubqueryType(SubqueryType.TABLE_SUBQUERY);
            result.add(subquery);
            SubqueryExtractUtil.extractSubquerySegments(result, subquery.getSelect());
        }
        if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractUtil.extractSubquerySegmentsFromTableSegment(result, ((JoinTableSegment)tableSegment).getLeft());
            SubqueryExtractUtil.extractSubquerySegmentsFromTableSegment(result, ((JoinTableSegment)tableSegment).getRight());
        }
    }

    private static void extractSubquerySegmentsFromExpression(List<SubquerySegment> result, ExpressionSegment expressionSegment) {
        Object subquery;
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            subquery = ((SubqueryExpressionSegment)expressionSegment).getSubquery();
            ((SubquerySegment)subquery).setSubqueryType(SubqueryType.PREDICATE_SUBQUERY);
            result.add((SubquerySegment)subquery);
            SubqueryExtractUtil.extractSubquerySegments(result, ((SubquerySegment)subquery).getSelect());
        }
        if (expressionSegment instanceof ListExpression) {
            for (ExpressionSegment each : ((ListExpression)expressionSegment).getItems()) {
                SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, each);
            }
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getLeft());
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof InExpression) {
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getLeft());
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof BetweenExpression) {
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getBetweenExpr());
            SubqueryExtractUtil.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getAndExpr());
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            subquery = ((ExistsSubqueryExpression)expressionSegment).getSubquery();
            ((SubquerySegment)subquery).setSubqueryType(SubqueryType.EXISTS_SUBQUERY);
            result.add((SubquerySegment)subquery);
            SubqueryExtractUtil.extractSubquerySegments(result, ((SubquerySegment)subquery).getSelect());
        }
    }

    @Generated
    private SubqueryExtractUtil() {
    }
}

