/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.value.identifier;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.ValueASTNode;

public final class IdentifierValue
implements ValueASTNode<String> {
    private final String value;
    private final QuoteCharacter quoteCharacter;

    public IdentifierValue(String text) {
        this(SQLUtil.getExactlyValue(text), QuoteCharacter.getQuoteCharacter(text));
    }

    public IdentifierValue(String text, String reservedCharacters) {
        this(SQLUtil.getExactlyValue(text, reservedCharacters), QuoteCharacter.getQuoteCharacter(text));
    }

    public String getValueWithQuoteCharacters() {
        return null == this.value ? "" : this.quoteCharacter.wrap(this.value);
    }

    public static String getQuotedContent(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        QuoteCharacter quoteCharacter = QuoteCharacter.getQuoteCharacter(text);
        if (quoteCharacter.equals((Object)QuoteCharacter.NONE)) {
            return text.trim();
        }
        return text.substring(1, text.length() - 1);
    }

    @Generated
    public IdentifierValue(String value, QuoteCharacter quoteCharacter) {
        this.value = value;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Generated
    public String toString() {
        return "IdentifierValue(value=" + this.getValue() + ", quoteCharacter=" + (Object)((Object)this.getQuoteCharacter()) + ")";
    }
}

