/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql92.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DMLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQL92StatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql92.visitor.statement.impl.SQL92StatementSQLVisitor;

public final class SQL92DMLStatementSQLVisitor
extends SQL92StatementSQLVisitor
implements DMLSQLVisitor,
SQLStatementVisitor {
    public SQL92DMLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitInsert(SQL92StatementParser.InsertContext ctx) {
        SQL92InsertStatement result = (SQL92InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(SQL92StatementParser.InsertValuesClauseContext ctx) {
        SQL92InsertStatement result = new SQL92InsertStatement();
        if (null != ctx.columnNames()) {
            SQL92StatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<SQL92StatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (SQL92StatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(SQL92StatementParser.UpdateContext ctx) {
        SQL92UpdateStatement result = new SQL92UpdateStatement();
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.tableReferences()));
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(SQL92StatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (SQL92StatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(SQL92StatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (SQL92StatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(SQL92StatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
        result.getColumns().add(column);
        return result;
    }

    @Override
    public ASTNode visitAssignmentValue(SQL92StatementParser.AssignmentValueContext ctx) {
        SQL92StatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(SQL92StatementParser.DeleteContext ctx) {
        SQL92DeleteStatement result = new SQL92DeleteStatement();
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(SQL92StatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(SQL92StatementParser.SelectContext ctx) {
        SQL92SelectStatement result = (SQL92SelectStatement)this.visit((ParseTree)ctx.unionClause());
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitUnionClause(SQL92StatementParser.UnionClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectClause(0));
    }

    @Override
    public ASTNode visitSelectClause(SQL92StatementParser.SelectClauseContext ctx) {
        SQL92SelectStatement result = new SQL92SelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (!ctx.selectSpecification().isEmpty()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx.selectSpecification().get(0)));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.fromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(SQL92StatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    private boolean isDistinct(SQL92StatementParser.SelectSpecificationContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitDuplicateSpecification(SQL92StatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjections(SQL92StatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (SQL92StatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(SQL92StatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            SQL92StatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitAlias(SQL92StatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(SQL92StatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment segment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = ((BinaryOperationExpression)projection).getStartIndex();
            int stopIndex = null != alias ? alias.getStopIndex() : ((BinaryOperationExpression)projection).getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, ((BinaryOperationExpression)projection).getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals())) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()));
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(SQL92StatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(SQL92StatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.escapedTableReference(0));
        if (ctx.escapedTableReference().size() > 1) {
            for (int i = 1; i < ctx.escapedTableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromEscapedTableReference(ctx.escapedTableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromEscapedTableReference(SQL92StatementParser.EscapedTableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitEscapedTableReference(SQL92StatementParser.EscapedTableReferenceContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReference());
    }

    @Override
    public ASTNode visitTableReference(SQL92StatementParser.TableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        if (!ctx.joinedTable().isEmpty()) {
            for (SQL92StatementParser.JoinedTableContext each : ctx.joinedTable()) {
                left = this.visitJoinedTable(each, left);
            }
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(SQL92StatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SQL92SelectStatement subquery = (SQL92SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery);
            SubqueryTableSegment result = new SubqueryTableSegment(subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(SQL92StatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        if (null != ctx.joinSpecification()) {
            result = this.visitJoinSpecification(ctx.joinSpecification(), result);
        }
        return result;
    }

    private JoinTableSegment visitJoinSpecification(SQL92StatementParser.JoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
        return joinTableSource;
    }

    @Override
    public ASTNode visitWhereClause(SQL92StatementParser.WhereClauseContext ctx) {
        ExpressionSegment segment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segment);
    }

    @Override
    public ASTNode visitGroupByClause(SQL92StatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (SQL92StatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitSubquery(SQL92StatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.unionClause());
    }

    @Generated
    public SQL92DMLStatementSQLVisitor() {
    }
}

