/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.table;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.segment.table.Table;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class TablesContext {
    private final Collection<Table> tables = new ArrayList<Table>();
    private String schema;

    public TablesContext(SQLStatement sqlStatement) {
        Optional<String> alias;
        HashSet<Object> aliases = new HashSet<Object>();
        for (TableAvailable each : sqlStatement.findSQLSegments(TableAvailable.class)) {
            alias = this.getAlias(each);
            if (!alias.isPresent()) continue;
            aliases.add(alias.get());
        }
        for (TableAvailable each : sqlStatement.findSQLSegments(TableAvailable.class)) {
            alias = this.getAlias(each);
            if (aliases.contains(each.getTableName()) && !alias.isPresent()) continue;
            this.tables.add(new Table(each.getTableName(), (String)alias.orNull()));
            if (!(each instanceof TableSegment)) continue;
            this.setSchema((TableSegment)each);
        }
    }

    private Optional<String> getAlias(TableAvailable table) {
        return table instanceof AliasAvailable ? ((AliasAvailable)table).getAlias() : Optional.absent();
    }

    private void setSchema(TableSegment tableSegment) {
        if (tableSegment.getOwner().isPresent()) {
            if (null != this.schema && !((SchemaSegment)tableSegment.getOwner().get()).getName().equalsIgnoreCase(this.schema)) {
                throw new UnsupportedOperationException("Cannot support multiple schemas in one SQL");
            }
            this.schema = ((SchemaSegment)tableSegment.getOwner().get()).getName();
        }
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public boolean isSingleTable() {
        TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Table each : this.tables) {
            tableNames.add(each.getName());
        }
        return 1 == tableNames.size();
    }

    public String getSingleTableName() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return this.tables.iterator().next().getName();
    }

    public Collection<String> getTableNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.tables.size(), 1.0f);
        for (Table each : this.tables) {
            result.add(each.getName());
        }
        return result;
    }

    public Optional<Table> find(String tableNameOrAlias) {
        Optional<Table> tableFromName = this.findTableFromName(tableNameOrAlias);
        return tableFromName.isPresent() ? tableFromName : this.findTableFromAlias(tableNameOrAlias);
    }

    private Optional<Table> findTableFromName(String name) {
        for (Table each : this.tables) {
            if (!each.getName().equals(name)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private Optional<Table> findTableFromAlias(String alias) {
        for (Table each : this.tables) {
            if (!each.getAlias().isPresent() || !((String)each.getAlias().get()).equalsIgnoreCase(alias)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Optional<String> findTableName(ColumnSegment columnSegment, RelationMetas relationMetas) {
        if (this.isSingleTable()) {
            return Optional.of((Object)this.getSingleTableName());
        }
        if (columnSegment.getOwner().isPresent()) {
            Optional<Table> table = this.find(((TableSegment)columnSegment.getOwner().get()).getTableName());
            return table.isPresent() ? Optional.of((Object)((Table)table.get()).getName()) : Optional.absent();
        }
        return this.findTableNameFromMetaData(columnSegment.getName(), relationMetas);
    }

    private Optional<String> findTableNameFromMetaData(String columnName, RelationMetas relationMetas) {
        for (String each : this.getTableNames()) {
            if (!relationMetas.containsColumn(each, columnName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Optional<String> getSchema() {
        return Optional.fromNullable((Object)this.schema);
    }

    public String toString() {
        return "TablesContext(tables=" + this.tables + ", schema=" + this.getSchema() + ")";
    }
}

